/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.component;

import icu.windea.breezeframework.core.component.AbstractStringMatcher;
import icu.windea.breezeframework.core.component.Component;
import icu.windea.breezeframework.core.component.ComponentRegistry;
import icu.windea.breezeframework.core.component.StringMatcher;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\n\u0006\u0007\b\t\n\u000b\f\r\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014\u00a8\u0006\u0010"}, d2={"Licu/windea/breezeframework/core/component/StringMatchers;", "Licu/windea/breezeframework/core/component/ComponentRegistry;", "Licu/windea/breezeframework/core/component/StringMatcher;", "()V", "registerDefault", "", "AlphaMatcher", "AlphanumericMatcher", "AnyMatcher", "BlankMatcher", "BooleanMatcher", "IntMatcher", "NoneMatcher", "NumberMatcher", "NumericMatcher", "WildcardBooleanMatcher", "breeze-core"})
public final class StringMatchers
extends ComponentRegistry<StringMatcher> {
    @NotNull
    public static final StringMatchers INSTANCE = new StringMatchers();

    private StringMatchers() {
    }

    @Override
    protected void registerDefault() {
        this.register((Component)AnyMatcher.INSTANCE);
        this.register((Component)NoneMatcher.INSTANCE);
        this.register((Component)BooleanMatcher.INSTANCE);
        this.register((Component)WildcardBooleanMatcher.INSTANCE);
        this.register((Component)IntMatcher.INSTANCE);
        this.register((Component)NumberMatcher.INSTANCE);
        this.register((Component)AlphaMatcher.INSTANCE);
        this.register((Component)NumericMatcher.INSTANCE);
        this.register((Component)AlphanumericMatcher.INSTANCE);
        this.register((Component)BlankMatcher.INSTANCE);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/StringMatchers$AnyMatcher;", "Licu/windea/breezeframework/core/component/AbstractStringMatcher;", "()V", "matches", "", "value", "", "breeze-core"})
    public static final class AnyMatcher
    extends AbstractStringMatcher {
        @NotNull
        public static final AnyMatcher INSTANCE = new AnyMatcher();

        private AnyMatcher() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return true;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/StringMatchers$NoneMatcher;", "Licu/windea/breezeframework/core/component/AbstractStringMatcher;", "()V", "matches", "", "value", "", "breeze-core"})
    public static final class NoneMatcher
    extends AbstractStringMatcher {
        @NotNull
        public static final NoneMatcher INSTANCE = new NoneMatcher();

        private NoneMatcher() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return false;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\n"}, d2={"Licu/windea/breezeframework/core/component/StringMatchers$BooleanMatcher;", "Licu/windea/breezeframework/core/component/AbstractStringMatcher;", "()V", "values", "", "", "[Ljava/lang/String;", "matches", "", "value", "breeze-core"})
    public static final class BooleanMatcher
    extends AbstractStringMatcher {
        @NotNull
        public static final BooleanMatcher INSTANCE = new BooleanMatcher();
        @NotNull
        private static final String[] values;

        private BooleanMatcher() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return ArraysKt.contains((Object[])values, (Object)value);
        }

        static {
            String[] stringArray = new String[]{"true", "false"};
            values = stringArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\n"}, d2={"Licu/windea/breezeframework/core/component/StringMatchers$WildcardBooleanMatcher;", "Licu/windea/breezeframework/core/component/AbstractStringMatcher;", "()V", "values", "", "", "[Ljava/lang/String;", "matches", "", "value", "breeze-core"})
    public static final class WildcardBooleanMatcher
    extends AbstractStringMatcher {
        @NotNull
        public static final WildcardBooleanMatcher INSTANCE = new WildcardBooleanMatcher();
        @NotNull
        private static final String[] values;

        private WildcardBooleanMatcher() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String string = value.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            return ArraysKt.contains((Object[])values, (Object)string);
        }

        static {
            String[] stringArray = new String[]{"true", "false", "yes", "no", "on", "off"};
            values = stringArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/StringMatchers$IntMatcher;", "Licu/windea/breezeframework/core/component/AbstractStringMatcher;", "()V", "signs", "", "matches", "", "value", "", "breeze-core"})
    public static final class IntMatcher
    extends AbstractStringMatcher {
        @NotNull
        public static final IntMatcher INSTANCE = new IntMatcher();
        @NotNull
        private static final char[] signs;

        private IntMatcher() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            boolean bl;
            block5: {
                String string;
                Character sign;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Character c = sign = StringsKt.firstOrNull((CharSequence)value);
                if (c == null) {
                    string = value;
                } else if (ArraysKt.contains((char[])signs, (char)c.charValue())) {
                    string = StringsKt.drop((String)value, (int)1);
                } else {
                    return false;
                }
                String noSignValue = string;
                CharSequence $this$any$iv = noSignValue;
                boolean $i$f$any = false;
                CharSequence charSequence = $this$any$iv;
                for (int i = 0; i < charSequence.length(); ++i) {
                    char element$iv = charSequence.charAt(i);
                    char it = element$iv;
                    boolean bl2 = false;
                    if (!Character.isDigit(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            return bl;
        }

        static {
            char[] cArray = new char[]{'+', '-'};
            signs = cArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Licu/windea/breezeframework/core/component/StringMatchers$NumberMatcher;", "Licu/windea/breezeframework/core/component/AbstractStringMatcher;", "()V", "signs", "", "matches", "", "value", "", "breeze-core"})
    public static final class NumberMatcher
    extends AbstractStringMatcher {
        @NotNull
        public static final NumberMatcher INSTANCE = new NumberMatcher();
        @NotNull
        private static final char[] signs;

        private NumberMatcher() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            boolean bl;
            block8: {
                String string;
                Character sign;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Character c = sign = StringsKt.firstOrNull((CharSequence)value);
                if (c == null) {
                    string = value;
                } else if (ArraysKt.contains((char[])signs, (char)c.charValue())) {
                    string = StringsKt.drop((String)value, (int)1);
                } else {
                    return false;
                }
                String noSignValue = string;
                boolean hasDot = false;
                CharSequence $this$any$iv = noSignValue;
                boolean $i$f$any = false;
                CharSequence charSequence = $this$any$iv;
                int n = 0;
                while (n < charSequence.length()) {
                    char element$iv = charSequence.charAt(n);
                    ++n;
                    char it = element$iv;
                    boolean bl2 = false;
                    if (it == '.') {
                        if (!hasDot) {
                            hasDot = true;
                        } else {
                            return false;
                        }
                    }
                    if (!Character.isDigit(it)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
            return bl;
        }

        static {
            char[] cArray = new char[]{'+', '-'};
            signs = cArray;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/StringMatchers$AlphaMatcher;", "Licu/windea/breezeframework/core/component/AbstractStringMatcher;", "()V", "matches", "", "value", "", "breeze-core"})
    public static final class AlphaMatcher
    extends AbstractStringMatcher {
        @NotNull
        public static final AlphaMatcher INSTANCE = new AlphaMatcher();

        private AlphaMatcher() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(@NotNull String value) {
            char it;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (((CharSequence)value).length() <= 0) return false;
            boolean bl = true;
            if (!bl) return false;
            CharSequence $this$all$iv = value;
            boolean $i$f$all = false;
            CharSequence charSequence = $this$all$iv;
            int n = 0;
            do {
                if (n >= charSequence.length()) return true;
                char element$iv = charSequence.charAt(n);
                ++n;
                it = element$iv;
                boolean bl2 = false;
            } while (Character.isLetter(it));
            return false;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/StringMatchers$NumericMatcher;", "Licu/windea/breezeframework/core/component/AbstractStringMatcher;", "()V", "matches", "", "value", "", "breeze-core"})
    public static final class NumericMatcher
    extends AbstractStringMatcher {
        @NotNull
        public static final NumericMatcher INSTANCE = new NumericMatcher();

        private NumericMatcher() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(@NotNull String value) {
            char it;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (((CharSequence)value).length() <= 0) return false;
            boolean bl = true;
            if (!bl) return false;
            CharSequence $this$all$iv = value;
            boolean $i$f$all = false;
            CharSequence charSequence = $this$all$iv;
            int n = 0;
            do {
                if (n >= charSequence.length()) return true;
                char element$iv = charSequence.charAt(n);
                ++n;
                it = element$iv;
                boolean bl2 = false;
            } while (Character.isDigit(it));
            return false;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/StringMatchers$AlphanumericMatcher;", "Licu/windea/breezeframework/core/component/AbstractStringMatcher;", "()V", "matches", "", "value", "", "breeze-core"})
    public static final class AlphanumericMatcher
    extends AbstractStringMatcher {
        @NotNull
        public static final AlphanumericMatcher INSTANCE = new AlphanumericMatcher();

        private AlphanumericMatcher() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean matches(@NotNull String value) {
            char it;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            if (((CharSequence)value).length() <= 0) return false;
            boolean bl = true;
            if (!bl) return false;
            CharSequence $this$all$iv = value;
            boolean $i$f$all = false;
            CharSequence charSequence = $this$all$iv;
            int n = 0;
            do {
                if (n >= charSequence.length()) return true;
                char element$iv = charSequence.charAt(n);
                ++n;
                it = element$iv;
                boolean bl2 = false;
            } while (Character.isLetterOrDigit(it));
            return false;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Licu/windea/breezeframework/core/component/StringMatchers$BlankMatcher;", "Licu/windea/breezeframework/core/component/AbstractStringMatcher;", "()V", "matches", "", "value", "", "breeze-core"})
    public static final class BlankMatcher
    extends AbstractStringMatcher {
        @NotNull
        public static final BlankMatcher INSTANCE = new BlankMatcher();

        private BlankMatcher() {
        }

        @Override
        public boolean matches(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return StringsKt.isBlank((CharSequence)value);
        }
    }
}

