/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.extension;

import icu.windea.breezeframework.core.annotation.UnstableApi;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0002\u001a\n\u0010\u0011\u001a\u00020\u0010*\u00020\u0002\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u0002\u001a\n\u0010\u0014\u001a\u00020\u0015*\u00020\u0002\u001a\f\u0010\u0016\u001a\u00020\n*\u00020\u0002H\u0007\u001a\u0016\u0010\u0017\u001a\u00020\u0002*\u00020\u00022\b\b\u0002\u0010\u0018\u001a\u00020\u0001H\u0007\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\"\u0015\u0010\u0007\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\u00a8\u0006\u0019"}, d2={"actualMimeType", "", "Ljava/io/File;", "getActualMimeType", "(Ljava/io/File;)Ljava/lang/String;", "mimeType", "getMimeType", "shortName", "getShortName", "addEntry", "", "base", "source", "outputStream", "Ljava/util/zip/ZipOutputStream;", "createDirectory", "", "createFile", "toUri", "Ljava/net/URI;", "toUrl", "Ljava/net/URL;", "unzip", "zip", "fileName", "breeze-core"})
@JvmName(name="FileExtensions")
public final class FileExtensions {
    @NotNull
    public static final String getShortName(@NotNull File $this$shortName) {
        Intrinsics.checkNotNullParameter((Object)$this$shortName, (String)"<this>");
        return FilesKt.getNameWithoutExtension((File)$this$shortName);
    }

    @Nullable
    public static final String getMimeType(@NotNull File $this$mimeType) {
        Intrinsics.checkNotNullParameter((Object)$this$mimeType, (String)"<this>");
        return URLConnection.guessContentTypeFromName($this$mimeType.getName());
    }

    @Nullable
    public static final String getActualMimeType(@NotNull File $this$actualMimeType) {
        Intrinsics.checkNotNullParameter((Object)$this$actualMimeType, (String)"<this>");
        return URLConnection.guessContentTypeFromStream(new FileInputStream($this$actualMimeType));
    }

    public static final boolean createFile(@NotNull File $this$createFile) {
        Intrinsics.checkNotNullParameter((Object)$this$createFile, (String)"<this>");
        $this$createFile.getParentFile().mkdirs();
        return $this$createFile.createNewFile();
    }

    public static final boolean createDirectory(@NotNull File $this$createDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$createDirectory, (String)"<this>");
        return $this$createDirectory.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnstableApi
    @NotNull
    public static final File zip(@NotNull File $this$zip, @NotNull String fileName) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$zip, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File source = $this$zip;
        if (!source.exists()) {
            boolean $i$a$-check-FileExtensions$zip$22 = false;
            String $i$a$-check-FileExtensions$zip$22 = "Source file or directory does not exist.";
            throw new IllegalStateException($i$a$-check-FileExtensions$zip$22.toString());
        }
        File target = new File(source.getParentFile(), fileName);
        if (target.exists()) {
            target.delete();
        }
        ZipOutputStream outputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(target)));
        Closeable closeable = outputStream;
        Throwable throwable = null;
        try {
            ZipOutputStream it = (ZipOutputStream)closeable;
            boolean bl = false;
            FileExtensions.addEntry("/", source, it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return target;
    }

    public static /* synthetic */ File zip$default(File file, String string, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            string = Intrinsics.stringPlus((String)file.getName(), (Object)".zip");
        }
        return FileExtensions.zip(file, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @UnstableApi
    public static final void unzip(@NotNull File $this$unzip) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$unzip, (String)"<this>");
        source = $this$unzip;
        if (!source.exists()) {
            $i$a$-check-FileExtensions$unzip$1 = false;
            $i$a$-check-FileExtensions$unzip$1 = "Source file does not exist.";
            throw new IllegalStateException($i$a$-check-FileExtensions$unzip$1.toString());
        }
        inputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(source)));
        entry = null;
        while (true) lbl-1000:
        // 3 sources

        {
            it = var4_6 = inputStream.getNextEntry();
            $i$a$-also-FileExtensions$unzip$2 = false;
            entry = it;
            if (var4_6 == null) ** break;
            v0 = entry;
            Intrinsics.checkNotNull((Object)v0);
            if (v0.isDirectory()) ** break;
            target = new File(source.getParent(), entry.getName());
            if (!target.getParentFile().exists()) {
                target.getParentFile().mkdirs();
            }
            buffer = new byte[10240];
            outputStream = new BufferedOutputStream(new FileOutputStream(target), buffer.length);
            var7_10 = outputStream;
            var8_11 = null;
            try {
                it = (BufferedOutputStream)var7_10;
                $i$a$-use-FileExtensions$unzip$3 = false;
                read = 0;
                while (true) {
                    it = var12_17 = inputStream.read(buffer, 0, buffer.length);
                    $i$a$-also-FileExtensions$unzip$3$1 = false;
                    read = it;
                    if (var12_17 == -1) break;
                    outputStream.write(buffer, 0, read);
                }
                outputStream.flush();
                var9_12 = Unit.INSTANCE;
            }
            catch (Throwable var9_13) {
                var8_11 = var9_13;
                throw var9_13;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var7_10, (Throwable)var8_11);
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        inputStream.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void addEntry(String base, File source, ZipOutputStream outputStream) throws IOException {
        block8: {
            String entry;
            block7: {
                entry = Intrinsics.stringPlus((String)base, (Object)source.getName());
                if (!source.isDirectory()) break block7;
                File[] fileArray = source.listFiles();
                if (fileArray == null) break block8;
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                for (File element$iv : $this$forEach$iv) {
                    File file = element$iv;
                    boolean bl = false;
                    String string = Intrinsics.stringPlus((String)entry, (Object)"/");
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                    FileExtensions.addEntry(string, file, outputStream);
                }
                break block8;
            }
            byte[] buffer = new byte[10240];
            BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(source), buffer.length);
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                BufferedInputStream it = (BufferedInputStream)closeable;
                boolean bl = false;
                int read = 0;
                outputStream.putNextEntry(new ZipEntry(entry));
                while (true) {
                    int n;
                    int it2 = n = inputStream.read(buffer, 0, buffer.length);
                    boolean bl2 = false;
                    read = it2;
                    if (n == -1) break;
                    outputStream.write(buffer, 0, read);
                }
                outputStream.closeEntry();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }

    @NotNull
    public static final URI toUri(@NotNull File $this$toUri) {
        Intrinsics.checkNotNullParameter((Object)$this$toUri, (String)"<this>");
        URI uRI = $this$toUri.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"this.toURI()");
        return uRI;
    }

    @NotNull
    public static final URL toUrl(@NotNull File $this$toUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$toUrl, (String)"<this>");
        URL uRL = $this$toUrl.toURI().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"this.toURI().toURL()");
        return uRL;
    }
}

