/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.extension;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u00a8\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0010\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\u001aE\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010%0\u00182\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010%0\u00182\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0(\"\u00020\tH\u0000\u00a2\u0006\u0002\u0010)\u001aE\u0010*\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010%0\u00182\u0014\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010%0\u00182\u0012\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0(\"\u00020\tH\u0000\u00a2\u0006\u0002\u0010)\u001a\u0014\u0010+\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010,\u001a\u00020\u0007H\u0000\u001a,\u0010-\u001a\b\u0012\u0004\u0012\u0002H.0\u0006\"\u0004\b\u0000\u0010.2\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u00100\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0000\u001a \u00101\u001a\u00020\u00072\n\u0010/\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u00100\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0000\u001a\u001c\u00102\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00170\u00062\u0006\u0010,\u001a\u00020\u0007H\u0000\u001a\u0010\u00103\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0007H\u0000\u001a)\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070(2\u0006\u0010,\u001a\u00020\u00072\n\u00105\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0000\u00a2\u0006\u0002\u00106\u001a\u000e\u00107\u001a\u000208*\u0004\u0018\u00010%H\u0000\u001a\u000e\u00109\u001a\u000208*\u0004\u0018\u00010%H\u0000\u001a\u001e\u0010:\u001a\b\u0012\u0004\u0012\u0002H.0\u001c\"\u0004\b\u0000\u0010.*\b\u0012\u0004\u0012\u0002H.0;H\u0000\u001a\u001e\u0010<\u001a\b\u0012\u0004\u0012\u0002H.0=\"\u0004\b\u0000\u0010.*\b\u0012\u0004\u0012\u0002H.0;H\u0000\u001a\u001e\u0010>\u001a\b\u0012\u0004\u0012\u0002H.0?\"\u0004\b\u0000\u0010.*\b\u0012\u0004\u0012\u0002H.0;H\u0000\u001a\u001e\u0010@\u001a\b\u0012\u0004\u0012\u0002H.0A\"\u0004\b\u0000\u0010.*\b\u0012\u0004\u0012\u0002H.0;H\u0000\u001a\u0010\u0010B\u001a\u0004\u0018\u00010\t*\u0004\u0018\u00010%H\u0000\u001a\f\u0010C\u001a\u00020\t*\u00020DH\u0000\u001a\f\u0010E\u001a\u00020\t*\u00020DH\u0000\u001a\f\u0010F\u001a\u00020\t*\u00020DH\u0000\u001a\f\u0010G\u001a\u00020H*\u00020IH\u0000\u001a\f\u0010J\u001a\u00020K*\u00020LH\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\".\u0010\u0004\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u000e\u0010\u0010\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0011\u001a\n \r*\u0004\u0018\u00010\u00120\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"<\u0010\u0015\u001a*\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00170\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u00180\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"6\u0010\u001b\u001a$\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00170\u0006\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u001c0\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001a\"\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"&\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001a\u00a8\u0006M"}, d2={"calendar", "Ljava/util/Calendar;", "getCalendar", "()Ljava/util/Calendar;", "componentTargetTypeMapCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/lang/Class;", "Ljava/lang/reflect/Type;", "defaultDateFormat", "", "defaultDateTimeFormat", "defaultLocale", "Ljava/util/Locale;", "kotlin.jvm.PlatformType", "getDefaultLocale", "()Ljava/util/Locale;", "defaultTimeFormat", "defaultTimeZone", "Ljava/util/TimeZone;", "getDefaultTimeZone", "()Ljava/util/TimeZone;", "enumValueMapCache", "", "", "", "getEnumValueMapCache", "()Ljava/util/Map;", "enumValuesCache", "", "getEnumValuesCache", "splitWordsRegex", "Lkotlin/text/Regex;", "threadLocalDateFormatMapCache", "Ljava/lang/ThreadLocal;", "Ljava/text/DateFormat;", "getThreadLocalDateFormatMapCache", "filterComponentParams", "", "componentParams", "names", "", "(Ljava/util/Map;[Ljava/lang/String;)Ljava/util/Map;", "filterNotComponentParams", "inferClass", "targetType", "inferComponentTargetClass", "T", "type", "componentType", "inferComponentTargetType", "inferEnumClass", "inferTypeArgument", "inferTypeArguments", "targetClass", "(Ljava/lang/reflect/Type;Ljava/lang/Class;)[Ljava/lang/reflect/Type;", "convertToBooleanOrFalse", "", "convertToBooleanOrTrue", "convertToList", "", "convertToMutableList", "", "convertToMutableSet", "", "convertToSet", "", "convertToStringOrNull", "firstCharToLowerCase", "", "firstCharToUpperCase", "splitWords", "toDoubleOrMax", "", "Ljava/math/BigDecimal;", "toLongOrMax", "", "Ljava/math/BigInteger;", "breeze-core"})
@JvmName(name="InternalExtensions")
public final class InternalExtensions {
    @NotNull
    public static final String defaultDateFormat = "yyyy-MM-dd";
    @NotNull
    public static final String defaultTimeFormat = "HH:mm:ss";
    @NotNull
    public static final String defaultDateTimeFormat = "yyyy-MM-dd HH:mm:ss";
    private static final Locale defaultLocale = Locale.getDefault(Locale.Category.FORMAT);
    private static final TimeZone defaultTimeZone = TimeZone.getTimeZone("UTC");
    @NotNull
    private static final Calendar calendar;
    @NotNull
    private static final Map<String, ThreadLocal<DateFormat>> threadLocalDateFormatMapCache;
    @NotNull
    private static final Map<Class<? extends Enum<?>>, List<Enum<?>>> enumValuesCache;
    @NotNull
    private static final Map<Class<? extends Enum<?>>, Map<String, Enum<?>>> enumValueMapCache;
    @NotNull
    private static final Regex splitWordsRegex;
    @NotNull
    private static final ConcurrentHashMap<Class<?>, ConcurrentHashMap<Class<?>, Type>> componentTargetTypeMapCache;

    public static final Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static final TimeZone getDefaultTimeZone() {
        return defaultTimeZone;
    }

    @NotNull
    public static final Calendar getCalendar() {
        return calendar;
    }

    @NotNull
    public static final Map<String, ThreadLocal<DateFormat>> getThreadLocalDateFormatMapCache() {
        return threadLocalDateFormatMapCache;
    }

    @NotNull
    public static final Map<Class<? extends Enum<?>>, List<Enum<?>>> getEnumValuesCache() {
        return enumValuesCache;
    }

    @NotNull
    public static final Map<Class<? extends Enum<?>>, Map<String, Enum<?>>> getEnumValueMapCache() {
        return enumValueMapCache;
    }

    public static final long toLongOrMax(@NotNull BigInteger $this$toLongOrMax) {
        Intrinsics.checkNotNullParameter((Object)$this$toLongOrMax, (String)"<this>");
        return $this$toLongOrMax.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) >= 0 ? Long.MAX_VALUE : $this$toLongOrMax.longValue();
    }

    public static final double toDoubleOrMax(@NotNull BigDecimal $this$toDoubleOrMax) {
        Intrinsics.checkNotNullParameter((Object)$this$toDoubleOrMax, (String)"<this>");
        return $this$toDoubleOrMax.compareTo(BigDecimal.valueOf(Double.MAX_VALUE)) >= 0 ? Double.MAX_VALUE : $this$toDoubleOrMax.doubleValue();
    }

    @NotNull
    public static final String firstCharToUpperCase(@NotNull CharSequence $this$firstCharToUpperCase) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$firstCharToUpperCase, (String)"<this>");
        if ($this$firstCharToUpperCase.length() == 0) {
            string = ((Object)$this$firstCharToUpperCase).toString();
        } else {
            char c = Character.toUpperCase($this$firstCharToUpperCase.charAt(0));
            CharSequence charSequence = $this$firstCharToUpperCase;
            int n = 1;
            int n2 = charSequence.length();
            charSequence = ((Object)charSequence.subSequence(n, n2)).toString();
            string = c + (String)charSequence;
        }
        return string;
    }

    @NotNull
    public static final String firstCharToLowerCase(@NotNull CharSequence $this$firstCharToLowerCase) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$firstCharToLowerCase, (String)"<this>");
        if ($this$firstCharToLowerCase.length() == 0) {
            string = ((Object)$this$firstCharToLowerCase).toString();
        } else {
            char c = Character.toLowerCase($this$firstCharToLowerCase.charAt(0));
            CharSequence charSequence = $this$firstCharToLowerCase;
            int n = 1;
            int n2 = charSequence.length();
            charSequence = ((Object)charSequence.subSequence(n, n2)).toString();
            string = c + (String)charSequence;
        }
        return string;
    }

    @NotNull
    public static final String splitWords(@NotNull CharSequence $this$splitWords) {
        Intrinsics.checkNotNullParameter((Object)$this$splitWords, (String)"<this>");
        CharSequence charSequence = $this$splitWords;
        Regex regex = splitWordsRegex;
        String string = " $1";
        return regex.replace(charSequence, string);
    }

    public static final boolean convertToBooleanOrTrue(@Nullable Object $this$convertToBooleanOrTrue) {
        return $this$convertToBooleanOrTrue == null || Intrinsics.areEqual((Object)$this$convertToBooleanOrTrue, (Object)true) || Intrinsics.areEqual((Object)$this$convertToBooleanOrTrue.toString(), (Object)"true");
    }

    public static final boolean convertToBooleanOrFalse(@Nullable Object $this$convertToBooleanOrFalse) {
        return $this$convertToBooleanOrFalse != null && (Intrinsics.areEqual((Object)$this$convertToBooleanOrFalse, (Object)true) || Intrinsics.areEqual((Object)$this$convertToBooleanOrFalse.toString(), (Object)"true"));
    }

    @Nullable
    public static final String convertToStringOrNull(@Nullable Object $this$convertToStringOrNull) {
        Object object = $this$convertToStringOrNull;
        return object == null ? null : object.toString();
    }

    @NotNull
    public static final <T> List<T> convertToList(@NotNull Collection<? extends T> $this$convertToList) {
        Intrinsics.checkNotNullParameter($this$convertToList, (String)"<this>");
        return $this$convertToList.size() == 0 ? CollectionsKt.emptyList() : ($this$convertToList.size() == 1 ? CollectionsKt.listOf($this$convertToList instanceof List ? ((List)$this$convertToList).get(0) : $this$convertToList.iterator().next()) : ($this$convertToList instanceof List ? (List)$this$convertToList : CollectionsKt.toMutableList($this$convertToList)));
    }

    @NotNull
    public static final <T> List<T> convertToMutableList(@NotNull Collection<? extends T> $this$convertToMutableList) {
        Intrinsics.checkNotNullParameter($this$convertToMutableList, (String)"<this>");
        return TypeIntrinsics.isMutableList($this$convertToMutableList) ? (List)$this$convertToMutableList : CollectionsKt.toMutableList($this$convertToMutableList);
    }

    @NotNull
    public static final <T> Set<T> convertToSet(@NotNull Collection<? extends T> $this$convertToSet) {
        Intrinsics.checkNotNullParameter($this$convertToSet, (String)"<this>");
        return $this$convertToSet.size() == 0 ? SetsKt.emptySet() : ($this$convertToSet.size() == 1 ? SetsKt.setOf($this$convertToSet instanceof List ? ((List)$this$convertToSet).get(0) : $this$convertToSet.iterator().next()) : ($this$convertToSet instanceof Set ? (Set)$this$convertToSet : CollectionsKt.toMutableSet((Iterable)$this$convertToSet)));
    }

    @NotNull
    public static final <T> Set<T> convertToMutableSet(@NotNull Collection<? extends T> $this$convertToMutableSet) {
        Intrinsics.checkNotNullParameter($this$convertToMutableSet, (String)"<this>");
        return TypeIntrinsics.isMutableSet($this$convertToMutableSet) ? (Set)$this$convertToMutableSet : CollectionsKt.toMutableSet((Iterable)$this$convertToMutableSet);
    }

    @NotNull
    public static final Class<?> inferClass(@NotNull Type targetType) {
        Class clazz;
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        if (targetType instanceof Class) {
            clazz = (Class)targetType;
        } else if (targetType instanceof ParameterizedType) {
            Type type = ((ParameterizedType)targetType).getRawType();
            clazz = type instanceof Class ? (Class)type : null;
            if (clazz == null) {
                throw new IllegalStateException(("Cannot infer class for target type '" + targetType + '\'').toString());
            }
        } else if (targetType instanceof WildcardType) {
            Object[] objectArray = ((WildcardType)targetType).getUpperBounds();
            Type type = objectArray == null ? null : (Type)ArraysKt.firstOrNull((Object[])objectArray);
            clazz = type instanceof Class ? (Class)type : null;
            if (clazz == null) {
                throw new IllegalStateException(("Cannot infer class for target type '" + targetType + '\'').toString());
            }
        } else {
            throw new IllegalStateException(("Cannot infer class for target type '" + targetType + '\'').toString());
        }
        return clazz;
    }

    @NotNull
    public static final Class<? extends Enum<?>> inferEnumClass(@NotNull Type targetType) {
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        if (!(targetType instanceof Class) || !((Class)targetType).isEnum()) {
            throw new IllegalStateException(("Cannot infer enum class for target type '" + targetType + '\'').toString());
        }
        return (Class)targetType;
    }

    @NotNull
    public static final Type inferTypeArgument(@NotNull Type targetType) {
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        if (targetType instanceof ParameterizedType) {
            Type type;
            Object[] objectArray = ((ParameterizedType)targetType).getActualTypeArguments();
            Type type2 = type = objectArray == null ? null : (Type)ArraysKt.firstOrNull((Object[])objectArray);
            if (type == null) {
                throw new IllegalStateException(("Cannot infer class for target type '" + targetType + '\'').toString());
            }
            return type;
        }
        if (targetType instanceof Class && ((Class)targetType).isArray()) {
            Class<?> clazz = ((Class)targetType).getComponentType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"targetType.componentType");
            return clazz;
        }
        throw new IllegalStateException(("Cannot infer class for target type '" + targetType + '\'').toString());
    }

    @NotNull
    public static final Type[] inferTypeArguments(@NotNull Type targetType, @NotNull Class<?> targetClass) {
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter(targetClass, (String)"targetClass");
        if (targetType instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)targetType).getRawType();
            Intrinsics.checkNotNullExpressionValue((Object)rawType, (String)"rawType");
            Class<?> rawClass = InternalExtensions.inferClass(rawType);
            if (Intrinsics.areEqual(rawClass, targetClass)) {
                Type[] typeArray = ((ParameterizedType)targetType).getActualTypeArguments();
                if (typeArray == null) {
                    throw new IllegalStateException(("Target type '" + targetType + "' should be a ParameterizedType of class '" + targetClass + '\'').toString());
                }
                return typeArray;
            }
        } else if (targetType instanceof Class && ((Class)targetType).isArray()) {
            Class[] classArray = new Class[]{((Class)targetType).getComponentType()};
            return classArray;
        }
        throw new IllegalStateException(("Target type '" + targetType + "' should be a ParameterizedType of class '" + targetClass + '\'').toString());
    }

    @NotNull
    public static final <T> Class<T> inferComponentTargetClass(@NotNull Class<?> type, @NotNull Class<?> componentType) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(componentType, (String)"componentType");
        Type type2 = InternalExtensions.inferComponentTargetType(type, componentType);
        Class clazz = type2 instanceof Class ? (Class)type2 : null;
        if (clazz == null) {
            throw new IllegalStateException(("Cannot infer target type for type '" + type + "'.").toString());
        }
        return clazz;
    }

    @NotNull
    public static final Type inferComponentTargetType(@NotNull Class<?> type, @NotNull Class<?> componentType) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(componentType, (String)"componentType");
        ConcurrentMap $this$getOrPut$iv = componentTargetTypeMapCache;
        boolean $i$f$getOrPut = false;
        Object v = $this$getOrPut$iv.get(componentType);
        if (v == null) {
            boolean bl = false;
            ConcurrentHashMap default$iv = new ConcurrentHashMap();
            boolean bl2 = false;
            object2 = $this$getOrPut$iv.putIfAbsent(componentType, default$iv);
            if (object2 == null) {
                object2 = default$iv;
            }
        } else {
            object2 = v;
        }
        ConcurrentHashMap targetMap = (ConcurrentHashMap)object2;
        ConcurrentMap $this$getOrPut$iv2 = targetMap;
        boolean $i$f$getOrPut2 = false;
        Object v2 = $this$getOrPut$iv2.get(type);
        if (v2 == null) {
            Type type2;
            block21: {
                boolean bl = false;
                Type currentType = type;
                while (!Intrinsics.areEqual((Object)currentType, Object.class)) {
                    Type genericInterface;
                    Type genericSuperClass;
                    block22: {
                        Type type3;
                        Class clazz;
                        if (currentType instanceof Class) {
                            clazz = (Class)currentType;
                        } else if (currentType instanceof ParameterizedType) {
                            Type bl2 = ((ParameterizedType)currentType).getRawType();
                            clazz = bl2 instanceof Class ? (Class)bl2 : null;
                            if (clazz == null) {
                                throw new IllegalStateException(("Cannot infer target type for type '" + type + "'.").toString());
                            }
                        } else {
                            throw new IllegalStateException(("Cannot infer target type for type '" + type + "'.").toString());
                        }
                        Class currentClass = clazz;
                        genericSuperClass = currentClass.getGenericSuperclass();
                        if (genericSuperClass instanceof ParameterizedType) {
                            Type[] bl2 = ((ParameterizedType)genericSuperClass).getActualTypeArguments();
                            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"genericSuperClass.actualTypeArguments");
                            if (!(((Object[])bl2).length == 0)) {
                                Type genericType = ((ParameterizedType)genericSuperClass).getActualTypeArguments()[0];
                                if (genericType instanceof Class) {
                                    type2 = genericType;
                                    break block21;
                                }
                                if (genericType instanceof ParameterizedType) {
                                    Type type4 = ((ParameterizedType)genericType).getRawType();
                                    Intrinsics.checkNotNullExpressionValue((Object)type4, (String)"genericType.rawType");
                                    return type4;
                                }
                            }
                        }
                        Type[] genericInterfaces = currentClass.getGenericInterfaces();
                        Intrinsics.checkNotNullExpressionValue((Object)genericInterfaces, (String)"genericInterfaces");
                        for (Type type5 : genericInterfaces) {
                            Type type6;
                            Type it = type5;
                            boolean bl3 = false;
                            if (!(it instanceof ParameterizedType && Intrinsics.areEqual((Object)((type6 = ((ParameterizedType)it).getRawType()) instanceof Class ? (Class)type6 : null), componentType))) continue;
                            type3 = type5;
                            break block22;
                        }
                        type3 = genericInterface = null;
                    }
                    if (genericInterface instanceof ParameterizedType) {
                        Type[] typeArray = ((ParameterizedType)genericInterface).getActualTypeArguments();
                        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"genericInterface.actualTypeArguments");
                        if (!(((Object[])typeArray).length == 0)) {
                            Type genericType = ((ParameterizedType)genericInterface).getActualTypeArguments()[0];
                            if (genericType instanceof Class) {
                                type2 = genericType;
                                break block21;
                            }
                            if (genericType instanceof ParameterizedType) {
                                Type type7 = ((ParameterizedType)genericType).getRawType();
                                Intrinsics.checkNotNullExpressionValue((Object)type7, (String)"genericType.rawType");
                                return type7;
                            }
                        }
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)genericSuperClass, (String)"genericSuperClass");
                    currentType = genericSuperClass;
                }
                throw new IllegalStateException(("Cannot infer target type for type '" + type + "'.").toString());
            }
            Type default$iv = type2;
            boolean bl = false;
            object = $this$getOrPut$iv2.putIfAbsent(type, default$iv);
            if (object == null) {
                object = default$iv;
            }
        } else {
            object = v2;
        }
        return (Type)object;
    }

    @NotNull
    public static final Map<String, Object> filterComponentParams(@NotNull Map<String, ? extends Object> componentParams, String ... names) {
        Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        if (componentParams.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map result = new LinkedHashMap();
        for (Map.Entry<String, ? extends Object> entry : componentParams.entrySet()) {
            String name = entry.getKey();
            Object configParam = entry.getValue();
            if (!ArraysKt.contains((Object[])names, (Object)name)) continue;
            result.put(name, configParam);
        }
        return result;
    }

    @NotNull
    public static final Map<String, Object> filterNotComponentParams(@NotNull Map<String, ? extends Object> componentParams, String ... names) {
        Intrinsics.checkNotNullParameter(componentParams, (String)"componentParams");
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        if (componentParams.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map result = new LinkedHashMap();
        for (Map.Entry<String, ? extends Object> entry : componentParams.entrySet()) {
            String name = entry.getKey();
            Object configParam = entry.getValue();
            if (ArraysKt.contains((Object[])names, (Object)name)) continue;
            result.put(name, configParam);
        }
        return result;
    }

    static {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"getInstance()");
        InternalExtensions.calendar = calendar;
        threadLocalDateFormatMapCache = new ConcurrentHashMap();
        enumValuesCache = new ConcurrentHashMap();
        enumValueMapCache = new ConcurrentHashMap();
        splitWordsRegex = new Regex("\\B([A-Z][a-z])");
        componentTargetTypeMapCache = new ConcurrentHashMap();
    }
}

