/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.extension;

import kotlin.Metadata;
import kotlin.jvm.JvmName;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0002\b\u0006\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00052\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0016\u0010\b\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\t\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0004\u001a\u0012\u0010\t\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0004\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0005\u001a\u0012\u0010\n\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0012\u0010\n\u001a\u00020\u0005*\u00020\u00042\u0006\u0010\u0002\u001a\u00020\u0005\u001a\u0012\u0010\n\u001a\u00020\u0005*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004\u00a8\u0006\f"}, d2={"ceil", "", "x", "precision", "", "", "", "floor", "round", "positivePow", "pow", "n", "breeze-core"})
@JvmName(name="MathExtensions")
public final class MathExtensions {
    public static final float pow(int $this$pow, int n) {
        return (float)Math.pow($this$pow, n);
    }

    public static final float pow(int $this$pow, float x) {
        return (float)Math.pow($this$pow, x);
    }

    public static final double pow(int $this$pow, double x) {
        return Math.pow($this$pow, x);
    }

    public static final float pow(float $this$pow, double x) {
        return (float)Math.pow($this$pow, (float)x);
    }

    public static final double pow(double $this$pow, float x) {
        return Math.pow($this$pow, x);
    }

    public static final int positivePow(int $this$positivePow, int x) {
        if (!(x >= 0)) {
            boolean bl = false;
            String string = "Number 'x' for positive pow operation must be non-negative, but was " + x + '.';
            throw new IllegalArgumentException(string.toString());
        }
        if (x == 0) {
            return 1;
        }
        int temp = $this$positivePow;
        int n = 1;
        while (n < x) {
            int i = n++;
            temp *= $this$positivePow;
        }
        return temp;
    }

    public static final long positivePow(long $this$positivePow, int x) {
        if (!(x >= 0)) {
            boolean bl = false;
            String string = "Number 'x' for positive pow operation must be non-negative, but was " + x + '.';
            throw new IllegalArgumentException(string.toString());
        }
        if (x == 0) {
            return 1L;
        }
        long temp = $this$positivePow;
        int n = 1;
        while (n < x) {
            int i = n++;
            temp *= $this$positivePow;
        }
        return temp;
    }

    public static final int ceil(int x, int precision) {
        int n;
        if (precision == 0) {
            n = x;
        } else if (precision > 0) {
            int it = MathExtensions.positivePow(10, precision);
            boolean bl = false;
            n = (int)Math.ceil((float)x / (float)it) * it;
        } else {
            throw new IllegalArgumentException("Precision for int ceil operation must be non-negative, but was " + precision + '.');
        }
        return n;
    }

    public static final long ceil(long x, int precision) {
        long l;
        if (precision == 0) {
            l = x;
        } else if (precision > 0) {
            int it = MathExtensions.positivePow(10, precision);
            boolean bl = false;
            l = (long)Math.ceil((float)x / (float)it) * (long)it;
        } else {
            throw new IllegalArgumentException("Precision for long ceil operation must be non-negative, but was " + precision + '.');
        }
        return l;
    }

    public static final float ceil(float x, int precision) {
        float f;
        if (precision == 0) {
            f = x;
        } else if (precision > 0) {
            int it = MathExtensions.positivePow(10, precision);
            boolean bl = false;
            f = (float)Math.ceil(x / (float)it) * (float)it;
        } else {
            int it = MathExtensions.positivePow(10, -precision);
            boolean bl = false;
            f = (float)Math.ceil(x * (float)it) / (float)it;
        }
        return f;
    }

    public static final double ceil(double x, int precision) {
        double d;
        if (precision == 0) {
            d = x;
        } else if (precision > 0) {
            int it = MathExtensions.positivePow(10, precision);
            boolean bl = false;
            d = Math.ceil(x / (double)it) * (double)it;
        } else {
            int it = MathExtensions.positivePow(10, -precision);
            boolean bl = false;
            d = Math.ceil(x * (double)it) / (double)it;
        }
        return d;
    }

    public static final int floor(int x, int precision) {
        int n;
        if (precision == 0) {
            n = x;
        } else if (precision > 0) {
            int it = MathExtensions.positivePow(10, precision);
            boolean bl = false;
            n = (int)Math.floor((float)x / (float)it) * it;
        } else {
            throw new IllegalArgumentException("Precision for int floor operation must be non-negative, but was " + precision + '.');
        }
        return n;
    }

    public static final long floor(long x, int precision) {
        long l;
        if (precision == 0) {
            l = x;
        } else if (precision > 0) {
            int it = MathExtensions.positivePow(10, precision);
            boolean bl = false;
            l = (long)Math.floor((float)x / (float)it) * (long)it;
        } else {
            throw new IllegalArgumentException("Precision for long floor operation must be non-negative, but was " + precision + '.');
        }
        return l;
    }

    public static final float floor(float x, int precision) {
        float f;
        if (precision == 0) {
            f = x;
        } else if (precision > 0) {
            int it = MathExtensions.positivePow(10, precision);
            boolean bl = false;
            f = (float)Math.floor(x / (float)it) * (float)it;
        } else {
            int it = MathExtensions.positivePow(10, -precision);
            boolean bl = false;
            f = (float)Math.floor(x * (float)it) / (float)it;
        }
        return f;
    }

    public static final double floor(double x, int precision) {
        double d;
        if (precision == 0) {
            d = x;
        } else if (precision > 0) {
            int it = MathExtensions.positivePow(10, precision);
            boolean bl = false;
            d = Math.floor(x / (double)it) * (double)it;
        } else {
            int it = MathExtensions.positivePow(10, -precision);
            boolean bl = false;
            d = Math.floor(x * (double)it) / (double)it;
        }
        return d;
    }

    public static final int round(int x, int precision) {
        int n;
        if (precision == 0) {
            n = x;
        } else if (precision > 0) {
            int it = MathExtensions.positivePow(10, precision);
            boolean bl = false;
            n = (int)Math.rint((float)x / (float)it) * it;
        } else {
            throw new IllegalArgumentException("Precision for int round operation must be non-negative, but was " + precision + '.');
        }
        return n;
    }

    public static final long round(long x, int precision) {
        long l;
        if (precision == 0) {
            l = x;
        } else if (precision > 0) {
            int it = MathExtensions.positivePow(10, precision);
            boolean bl = false;
            l = (long)Math.rint((float)x / (float)it) * (long)it;
        } else {
            throw new IllegalArgumentException("Precision for long round operation must be non-negative, but was " + precision + '.');
        }
        return l;
    }

    public static final float round(float x, int precision) {
        float f;
        if (precision == 0) {
            f = x;
        } else if (precision > 0) {
            int it = MathExtensions.positivePow(10, precision);
            boolean bl = false;
            f = (float)Math.rint(x / (float)it) * (float)it;
        } else {
            int it = MathExtensions.positivePow(10, -precision);
            boolean bl = false;
            f = (float)Math.rint(x * (float)it) / (float)it;
        }
        return f;
    }

    public static final double round(double x, int precision) {
        double d;
        if (precision == 0) {
            d = x;
        } else if (precision > 0) {
            int it = MathExtensions.positivePow(10, precision);
            boolean bl = false;
            d = Math.rint(x / (double)it) * (double)it;
        } else {
            int it = MathExtensions.positivePow(10, -precision);
            boolean bl = false;
            d = Math.rint(x * (double)it) / (double)it;
        }
        return d;
    }
}

