/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.extension;

import icu.windea.breezeframework.core.annotation.UnstableApi;
import icu.windea.breezeframework.core.extension.InternalExtensions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UShort;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0084\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007\u001a \u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r\u001a\u001a\u0010\b\u001a\u00020\t*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\t\u001a&\u0010\u000f\u001a\u00020\u0010*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00102\u0006\u0010\u0004\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007\u001a\u001e\u0010\u000f\u001a\u00020\u0010*\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007\u001a\u0016\u0010\u000f\u001a\u00020\u0010*\u00020\n2\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007\u001a\f\u0010\u0013\u001a\u00020\u0014*\u00020\nH\u0007\u001a\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0014H\u0007\u001a\u001c\u0010\u0013\u001a\u00020\u0014*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0014H\u0007\u001a\n\u0010\u0015\u001a\u00020\u0016*\u00020\n\u001a\u0012\u0010\u0015\u001a\u00020\u0016*\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0016\u001a\u001a\u0010\u0015\u001a\u00020\u0016*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0016\u001a\n\u0010\u0017\u001a\u00020\u0018*\u00020\n\u001a\u0012\u0010\u0017\u001a\u00020\u0018*\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0018\u001a\u001a\u0010\u0017\u001a\u00020\u0018*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u0018\u001a%\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a*\u00020\n2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001a0\u001c\u00a2\u0006\u0002\u0010\u001d\u001a\u0012\u0010\u0019\u001a\u00020\u0018*\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0001\u001a#\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a*\u00020\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001f\u00a2\u0006\u0002\u0010 \u001a\u0012\u0010!\u001a\u00020\u0007*\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0007\u001a\u001a\u0010!\u001a\u00020\u0007*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0007\u001a\n\u0010\"\u001a\u00020#*\u00020\n\u001a\u0012\u0010\"\u001a\u00020#*\u00020\n2\u0006\u0010\u0004\u001a\u00020#\u001a\u001a\u0010\"\u001a\u00020#*\u00020\n2\u0006\u0010\u0002\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020#\u001a\u001a\u0010$\u001a\u00020\u0001*\u00020\n2\u0006\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020'\u001a\u0012\u0010(\u001a\u00020)*\u00020\n\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*\u001a\u001f\u0010(\u001a\u00020)*\u00020\n2\u0006\u0010\u0004\u001a\u00020)\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b+\u0010,\u001a'\u0010(\u001a\u00020)*\u00020\n2\u0006\u0010\u0002\u001a\u00020)2\u0006\u0010\u0004\u001a\u00020)\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b-\u0010.\u001a\u0012\u0010/\u001a\u000200*\u00020\n\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101\u001a\u001f\u0010/\u001a\u000200*\u00020\n2\u0006\u0010\u0004\u001a\u000200\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b2\u00103\u001a'\u0010/\u001a\u000200*\u00020\n2\u0006\u0010\u0002\u001a\u0002002\u0006\u0010\u0004\u001a\u000200\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b4\u00105\u001a\n\u00106\u001a\u000207*\u00020\n\u001a\u0012\u00106\u001a\u000207*\u00020\n2\u0006\u00108\u001a\u00020\u0001\u001a\n\u00109\u001a\u00020\u0001*\u00020\n\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006:"}, d2={"boundsErrorMessage", "", "from", "", "until", "checkRangeBounds", "", "", "checkChance", "", "Lkotlin/random/Random;", "chance", "predicate", "Lkotlin/Function0;", "condition", "nextBigDecimal", "Ljava/math/BigDecimal;", "mathContext", "Ljava/math/MathContext;", "nextBigInteger", "Ljava/math/BigInteger;", "nextByte", "", "nextChar", "", "nextElement", "T", "elements", "", "(Lkotlin/random/Random;[Ljava/lang/Object;)Ljava/lang/Object;", "string", "", "(Lkotlin/random/Random;Ljava/util/List;)Ljava/lang/Object;", "nextFloat", "nextShort", "", "nextString", "source", "length", "", "nextUByte", "Lkotlin/UByte;", "(Lkotlin/random/Random;)B", "nextUByte-EK-6454", "(Lkotlin/random/Random;B)B", "nextUByte-8olNwgk", "(Lkotlin/random/Random;BB)B", "nextUShort", "Lkotlin/UShort;", "(Lkotlin/random/Random;)S", "nextUShort-i8woANY", "(Lkotlin/random/Random;S)S", "nextUShort-lwaoQsk", "(Lkotlin/random/Random;SS)S", "nextUuid", "Ljava/util/UUID;", "name", "nextUuidString", "breeze-core"})
@JvmName(name="RandomExtensions")
public final class RandomExtensions {
    public static final byte nextByte(@NotNull Random $this$nextByte) {
        Intrinsics.checkNotNullParameter((Object)$this$nextByte, (String)"<this>");
        return (byte)$this$nextByte.nextInt(-128, 127);
    }

    public static final byte nextByte(@NotNull Random $this$nextByte, byte until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextByte, (String)"<this>");
        return (byte)$this$nextByte.nextInt((int)until);
    }

    public static final byte nextByte(@NotNull Random $this$nextByte, byte from, byte until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextByte, (String)"<this>");
        return (byte)$this$nextByte.nextInt((int)from, (int)until);
    }

    public static final short nextShort(@NotNull Random $this$nextShort) {
        Intrinsics.checkNotNullParameter((Object)$this$nextShort, (String)"<this>");
        return (short)$this$nextShort.nextInt(Short.MIN_VALUE, Short.MAX_VALUE);
    }

    public static final short nextShort(@NotNull Random $this$nextShort, short until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextShort, (String)"<this>");
        return (short)$this$nextShort.nextInt((int)until);
    }

    public static final short nextShort(@NotNull Random $this$nextShort, short from, short until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextShort, (String)"<this>");
        return (short)$this$nextShort.nextInt((int)from, (int)until);
    }

    public static final float nextFloat(@NotNull Random $this$nextFloat, float until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextFloat, (String)"<this>");
        return RandomExtensions.nextFloat($this$nextFloat, 0.0f, until);
    }

    public static final float nextFloat(@NotNull Random $this$nextFloat, float from, float until) {
        float f;
        float f2;
        Intrinsics.checkNotNullParameter((Object)$this$nextFloat, (String)"<this>");
        RandomExtensions.checkRangeBounds(from, until);
        float size = until - from;
        if (Float.isInfinite(size) && !Float.isInfinite(f2 = from) && !Float.isNaN(f2) && !Float.isInfinite(f2 = until) && !Float.isNaN(f2)) {
            float r1 = $this$nextFloat.nextFloat() * (until / (float)2 - from / (float)2);
            f = from + r1 + r1;
        } else {
            f = from + $this$nextFloat.nextFloat() * size;
        }
        float r = f;
        return r >= until ? Math.nextAfter(until, Double.NEGATIVE_INFINITY) : r;
    }

    public static final void checkRangeBounds(float from, float until) {
        if (!(until > from)) {
            boolean bl = false;
            String string = RandomExtensions.boundsErrorMessage(Float.valueOf(from), Float.valueOf(until));
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public static final String boundsErrorMessage(@NotNull Object from, @NotNull Object until) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)until, (String)"until");
        return "Random range is empty: [" + from + ", " + until + ").";
    }

    public static final char nextChar(@NotNull Random $this$nextChar) {
        Intrinsics.checkNotNullParameter((Object)$this$nextChar, (String)"<this>");
        return (char)$this$nextChar.nextInt(0, 65535);
    }

    public static final char nextChar(@NotNull Random $this$nextChar, char until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextChar, (String)"<this>");
        return (char)$this$nextChar.nextInt((int)until);
    }

    public static final char nextChar(@NotNull Random $this$nextChar, char from, char until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextChar, (String)"<this>");
        return (char)$this$nextChar.nextInt((int)from, (int)until);
    }

    @UnstableApi
    @NotNull
    public static final BigInteger nextBigInteger(@NotNull Random $this$nextBigInteger) {
        Intrinsics.checkNotNullParameter((Object)$this$nextBigInteger, (String)"<this>");
        BigInteger bigInteger = BigInteger.valueOf($this$nextBigInteger.nextLong());
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(this)");
        return bigInteger;
    }

    @UnstableApi
    @NotNull
    public static final BigInteger nextBigInteger(@NotNull Random $this$nextBigInteger, @NotNull BigInteger until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextBigInteger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)until, (String)"until");
        BigInteger bigInteger = BigInteger.valueOf($this$nextBigInteger.nextLong(InternalExtensions.toLongOrMax(until)));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(this)");
        return bigInteger;
    }

    @UnstableApi
    @NotNull
    public static final BigInteger nextBigInteger(@NotNull Random $this$nextBigInteger, @NotNull BigInteger from, @NotNull BigInteger until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextBigInteger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)until, (String)"until");
        BigInteger bigInteger = BigInteger.valueOf($this$nextBigInteger.nextLong(InternalExtensions.toLongOrMax(from), InternalExtensions.toLongOrMax(until)));
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(this)");
        return bigInteger;
    }

    @UnstableApi
    @NotNull
    public static final BigDecimal nextBigDecimal(@NotNull Random $this$nextBigDecimal, @NotNull MathContext mathContext) {
        Intrinsics.checkNotNullParameter((Object)$this$nextBigDecimal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)mathContext, (String)"mathContext");
        double d = $this$nextBigDecimal.nextDouble();
        return new BigDecimal(String.valueOf(d), mathContext);
    }

    public static /* synthetic */ BigDecimal nextBigDecimal$default(Random random, MathContext mathContext, int n, Object object) {
        if ((n & 1) != 0) {
            MathContext mathContext2 = MathContext.UNLIMITED;
            Intrinsics.checkNotNullExpressionValue((Object)mathContext2, (String)"UNLIMITED");
            mathContext = mathContext2;
        }
        return RandomExtensions.nextBigDecimal(random, mathContext);
    }

    @UnstableApi
    @NotNull
    public static final BigDecimal nextBigDecimal(@NotNull Random $this$nextBigDecimal, @NotNull BigDecimal until, @NotNull MathContext mathContext) {
        Intrinsics.checkNotNullParameter((Object)$this$nextBigDecimal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)until, (String)"until");
        Intrinsics.checkNotNullParameter((Object)mathContext, (String)"mathContext");
        double d = $this$nextBigDecimal.nextDouble(InternalExtensions.toDoubleOrMax(until));
        return new BigDecimal(String.valueOf(d), mathContext);
    }

    public static /* synthetic */ BigDecimal nextBigDecimal$default(Random random, BigDecimal bigDecimal, MathContext mathContext, int n, Object object) {
        if ((n & 2) != 0) {
            MathContext mathContext2 = MathContext.UNLIMITED;
            Intrinsics.checkNotNullExpressionValue((Object)mathContext2, (String)"UNLIMITED");
            mathContext = mathContext2;
        }
        return RandomExtensions.nextBigDecimal(random, bigDecimal, mathContext);
    }

    @UnstableApi
    @NotNull
    public static final BigDecimal nextBigDecimal(@NotNull Random $this$nextBigDecimal, @NotNull BigDecimal from, @NotNull BigDecimal until, @NotNull MathContext mathContext) {
        Intrinsics.checkNotNullParameter((Object)$this$nextBigDecimal, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)until, (String)"until");
        Intrinsics.checkNotNullParameter((Object)mathContext, (String)"mathContext");
        double d = $this$nextBigDecimal.nextDouble(InternalExtensions.toDoubleOrMax(from), InternalExtensions.toDoubleOrMax(until));
        return new BigDecimal(String.valueOf(d), mathContext);
    }

    public static /* synthetic */ BigDecimal nextBigDecimal$default(Random random, BigDecimal bigDecimal, BigDecimal bigDecimal2, MathContext mathContext, int n, Object object) {
        if ((n & 4) != 0) {
            MathContext mathContext2 = MathContext.UNLIMITED;
            Intrinsics.checkNotNullExpressionValue((Object)mathContext2, (String)"UNLIMITED");
            mathContext = mathContext2;
        }
        return RandomExtensions.nextBigDecimal(random, bigDecimal, bigDecimal2, mathContext);
    }

    public static final byte nextUByte(@NotNull Random $this$nextUByte) {
        Intrinsics.checkNotNullParameter((Object)$this$nextUByte, (String)"<this>");
        return UByte.constructor-impl((byte)((byte)$this$nextUByte.nextInt(0 & 0xFF, 0xFFFFFFFF & 0xFF)));
    }

    public static final byte nextUByte-EK-6454(@NotNull Random $this$nextUByte, byte until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextUByte, (String)"$this$nextUByte");
        return UByte.constructor-impl((byte)((byte)$this$nextUByte.nextInt(until & 0xFF)));
    }

    public static final byte nextUByte-8olNwgk(@NotNull Random $this$nextUByte, byte from, byte until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextUByte, (String)"$this$nextUByte");
        return UByte.constructor-impl((byte)((byte)$this$nextUByte.nextInt(from & 0xFF, until & 0xFF)));
    }

    public static final short nextUShort(@NotNull Random $this$nextUShort) {
        Intrinsics.checkNotNullParameter((Object)$this$nextUShort, (String)"<this>");
        return UShort.constructor-impl((short)((short)$this$nextUShort.nextInt(0 & 0xFFFF, 0xFFFFFFFF & 0xFFFF)));
    }

    public static final short nextUShort-i8woANY(@NotNull Random $this$nextUShort, short until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextUShort, (String)"$this$nextUShort");
        return UShort.constructor-impl((short)((short)$this$nextUShort.nextInt(until & 0xFFFF)));
    }

    public static final short nextUShort-lwaoQsk(@NotNull Random $this$nextUShort, short from, short until) {
        Intrinsics.checkNotNullParameter((Object)$this$nextUShort, (String)"$this$nextUShort");
        return UShort.constructor-impl((short)((short)$this$nextUShort.nextInt(from & 0xFFFF, until & 0xFFFF)));
    }

    @NotNull
    public static final String nextString(@NotNull Random $this$nextString, @NotNull String source, int length) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$nextString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int sourceLength = source.length();
        if (length < 0) {
            throw new IllegalArgumentException("Length cannot be negetive.");
        }
        if (length == 0) {
            string = "";
        } else {
            StringBuilder stringBuilder;
            StringBuilder $this$nextString_u24lambda_u2d2 = stringBuilder = new StringBuilder();
            boolean bl = false;
            int n = 0;
            while (n < length) {
                int n2;
                int it = n2 = n++;
                boolean bl2 = false;
                $this$nextString_u24lambda_u2d2.append(source.charAt($this$nextString.nextInt(sourceLength)));
            }
            String string2 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            string = string2;
        }
        return string;
    }

    @NotNull
    public static final UUID nextUuid(@NotNull Random $this$nextUuid) {
        Intrinsics.checkNotNullParameter((Object)$this$nextUuid, (String)"<this>");
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID()");
        return uUID;
    }

    @NotNull
    public static final UUID nextUuid(@NotNull Random $this$nextUuid, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$nextUuid, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        UUID uUID = UUID.nameUUIDFromBytes(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"nameUUIDFromBytes(name.toByteArray())");
        return uUID;
    }

    @NotNull
    public static final String nextUuidString(@NotNull Random $this$nextUuidString) {
        Intrinsics.checkNotNullParameter((Object)$this$nextUuidString, (String)"<this>");
        String string = RandomExtensions.nextUuid($this$nextUuidString).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextUuid().toString()");
        return string;
    }

    public static final char nextElement(@NotNull Random $this$nextElement, @NotNull String string) {
        char c;
        Intrinsics.checkNotNullParameter((Object)$this$nextElement, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int length = string.length();
        switch (length) {
            case 0: {
                throw new IllegalArgumentException("Elements cannot be empty.");
            }
            case 1: {
                c = string.charAt(0);
                break;
            }
            default: {
                c = string.charAt($this$nextElement.nextInt(length));
            }
        }
        return c;
    }

    public static final <T> T nextElement(@NotNull Random $this$nextElement, @NotNull T[] elements) {
        T t;
        Intrinsics.checkNotNullParameter((Object)$this$nextElement, (String)"<this>");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int size = elements.length;
        switch (size) {
            case 0: {
                throw new IllegalArgumentException("Elements cannot be empty.");
            }
            case 1: {
                t = elements[0];
                break;
            }
            default: {
                t = elements[$this$nextElement.nextInt(size)];
            }
        }
        return t;
    }

    public static final <T> T nextElement(@NotNull Random $this$nextElement, @NotNull List<? extends T> elements) {
        T t;
        Intrinsics.checkNotNullParameter((Object)$this$nextElement, (String)"<this>");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int size = elements.size();
        switch (size) {
            case 0: {
                throw new IllegalArgumentException("Elements cannot be empty.");
            }
            case 1: {
                t = elements.get(0);
                break;
            }
            default: {
                t = elements.get($this$nextElement.nextInt(size));
            }
        }
        return t;
    }

    public static final boolean checkChance(@NotNull Random $this$checkChance, float chance) {
        Intrinsics.checkNotNullParameter((Object)$this$checkChance, (String)"<this>");
        if (!(0.0f <= chance ? chance <= 1.0f : false)) {
            boolean bl = false;
            String string = "Chance must between 0 and 1, but was " + chance + '.';
            throw new IllegalArgumentException(string.toString());
        }
        return chance == 1.0f ? true : (chance == 0.0f ? false : (0.0f <= chance ? chance <= $this$checkChance.nextFloat() : false));
    }

    public static final boolean checkChance(@NotNull Random $this$checkChance, float chance, boolean condition) {
        Intrinsics.checkNotNullParameter((Object)$this$checkChance, (String)"<this>");
        return condition && RandomExtensions.checkChance($this$checkChance, chance);
    }

    public static final boolean checkChance(@NotNull Random $this$checkChance, float chance, @NotNull Function0<Boolean> predicate) {
        Intrinsics.checkNotNullParameter((Object)$this$checkChance, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return (Boolean)predicate.invoke() != false && RandomExtensions.checkChance($this$checkChance, chance);
    }
}

