/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.extension;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.MonthDay;
import java.time.Year;
import java.time.YearMonth;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\r\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0086\u0002\u001a\r\u0010\u0000\u001a\u00020\u0002*\u00020\u0002H\u0086\u0002\u001a\r\u0010\u0000\u001a\u00020\u0003*\u00020\u0003H\u0086\u0002\u001a\r\u0010\u0004\u001a\u00020\u0001*\u00020\u0001H\u0086\u0002\u001a\r\u0010\u0004\u001a\u00020\u0002*\u00020\u0002H\u0086\u0002\u001a\r\u0010\u0004\u001a\u00020\u0003*\u00020\u0003H\u0086\u0002\u001a\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0002\u001a\u0015\u0010\u0005\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0086\u0002\u001a\u0015\u0010\u0005\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\t\u001a\u00020\u0007H\u0086\u0002\u001a\u0015\u0010\u0005\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0086\u0002\u001a\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0086\u0002\u001a\u0015\u0010\u000b\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0086\u0002\u001a\u0015\u0010\u000b\u001a\u00020\f*\u00020\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0086\u0002\u001a\u0015\u0010\u000b\u001a\u00020\u000e*\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002\u001a\u0015\u0010\u000b\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\t\u001a\u00020\u0007H\u0086\u0002\u001a\u0015\u0010\u000b\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0086\u0002\u00a8\u0006\u0011"}, d2={"dec", "Ljava/time/DayOfWeek;", "Ljava/time/Month;", "Ljava/time/Year;", "inc", "minus", "days", "", "months", "years", "", "plus", "Ljava/time/YearMonth;", "month", "Ljava/time/LocalDate;", "monthDay", "Ljava/time/MonthDay;", "breeze-core"})
@JvmName(name="TemporalExtensions")
public final class TemporalExtensions {
    @NotNull
    public static final Year plus(@NotNull Year $this$plus, int years) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Year year = $this$plus.plusYears(years);
        Intrinsics.checkNotNullExpressionValue((Object)year, (String)"this.plusYears(years.toLong())");
        return year;
    }

    @NotNull
    public static final Year plus(@NotNull Year $this$plus, long years) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Year year = $this$plus.plusYears(years);
        Intrinsics.checkNotNullExpressionValue((Object)year, (String)"this.plusYears(years)");
        return year;
    }

    @NotNull
    public static final YearMonth plus(@NotNull Year $this$plus, @NotNull Month month) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)month, (String)"month");
        YearMonth yearMonth = $this$plus.atMonth(month);
        Intrinsics.checkNotNullExpressionValue((Object)yearMonth, (String)"this.atMonth(month)");
        return yearMonth;
    }

    @NotNull
    public static final LocalDate plus(@NotNull Year $this$plus, @NotNull MonthDay monthDay) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)monthDay, (String)"monthDay");
        LocalDate localDate = $this$plus.atMonthDay(monthDay);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"atMonthDay(monthDay)");
        return localDate;
    }

    @NotNull
    public static final Year minus(@NotNull Year $this$minus, int years) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Year year = $this$minus.minusYears(years);
        Intrinsics.checkNotNullExpressionValue((Object)year, (String)"this.minusYears(years.toLong())");
        return year;
    }

    @NotNull
    public static final Year minus(@NotNull Year $this$minus, long years) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Year year = $this$minus.minusYears(years);
        Intrinsics.checkNotNullExpressionValue((Object)year, (String)"this.minusYears(years)");
        return year;
    }

    @NotNull
    public static final Year inc(@NotNull Year $this$inc) {
        Intrinsics.checkNotNullParameter((Object)$this$inc, (String)"<this>");
        Year year = $this$inc.plusYears(1L);
        Intrinsics.checkNotNullExpressionValue((Object)year, (String)"this.plusYears(1L)");
        return year;
    }

    @NotNull
    public static final Year dec(@NotNull Year $this$dec) {
        Intrinsics.checkNotNullParameter((Object)$this$dec, (String)"<this>");
        Year year = $this$dec.minusYears(1L);
        Intrinsics.checkNotNullExpressionValue((Object)year, (String)"this.minusYears(1L)");
        return year;
    }

    @NotNull
    public static final Month plus(@NotNull Month $this$plus, int months) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Month month = $this$plus.plus(months);
        Intrinsics.checkNotNullExpressionValue((Object)month, (String)"this.plus(months.toLong())");
        return month;
    }

    @NotNull
    public static final Month minus(@NotNull Month $this$minus, int months) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Month month = $this$minus.minus(months);
        Intrinsics.checkNotNullExpressionValue((Object)month, (String)"this.minus(months.toLong())");
        return month;
    }

    @NotNull
    public static final Month inc(@NotNull Month $this$inc) {
        Intrinsics.checkNotNullParameter((Object)$this$inc, (String)"<this>");
        Month month = $this$inc.plus(1L);
        Intrinsics.checkNotNullExpressionValue((Object)month, (String)"this.plus(1L)");
        return month;
    }

    @NotNull
    public static final Month dec(@NotNull Month $this$dec) {
        Intrinsics.checkNotNullParameter((Object)$this$dec, (String)"<this>");
        Month month = $this$dec.minus(1L);
        Intrinsics.checkNotNullExpressionValue((Object)month, (String)"this.minus(1L)");
        return month;
    }

    @NotNull
    public static final DayOfWeek plus(@NotNull DayOfWeek $this$plus, int days) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        DayOfWeek dayOfWeek = $this$plus.plus(days);
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"this.plus(days.toLong())");
        return dayOfWeek;
    }

    @NotNull
    public static final DayOfWeek minus(@NotNull DayOfWeek $this$minus, int days) {
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        DayOfWeek dayOfWeek = $this$minus.minus(days);
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"this.minus(days.toLong())");
        return dayOfWeek;
    }

    @NotNull
    public static final DayOfWeek inc(@NotNull DayOfWeek $this$inc) {
        Intrinsics.checkNotNullParameter((Object)$this$inc, (String)"<this>");
        DayOfWeek dayOfWeek = $this$inc.plus(1L);
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"this.plus(1L)");
        return dayOfWeek;
    }

    @NotNull
    public static final DayOfWeek dec(@NotNull DayOfWeek $this$dec) {
        Intrinsics.checkNotNullParameter((Object)$this$dec, (String)"<this>");
        DayOfWeek dayOfWeek = $this$dec.minus(1L);
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"this.minus(1L)");
        return dayOfWeek;
    }
}

