/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.core.model;

import icu.windea.breezeframework.core.model.Page;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B)\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010\u001b\u001a\u00020\u0006H\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0015\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006\u001c"}, d2={"Licu/windea/breezeframework/core/model/PageImpl;", "T", "Licu/windea/breezeframework/core/model/Page;", "source", "", "pageNumber", "", "pageSize", "(Ljava/util/List;II)V", "content", "getContent", "()Ljava/util/List;", "fromIndex", "getFromIndex", "()I", "getPageNumber", "getPageSize", "toIndex", "getToIndex", "total", "getTotal", "totalPage", "getTotalPage", "equals", "", "other", "", "hashCode", "breeze-core"})
public final class PageImpl<T>
implements Page<T> {
    private final int pageNumber;
    private final int pageSize;
    private final int total;
    private final int totalPage;
    private final int fromIndex;
    private final int toIndex;
    @NotNull
    private final List<T> content;

    public PageImpl(@NotNull List<? extends T> source, int pageNumber, int pageSize) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        this.pageNumber = RangesKt.coerceAtLeast((int)pageNumber, (int)0);
        this.pageSize = RangesKt.coerceAtLeast((int)pageSize, (int)0);
        this.total = source.size();
        this.totalPage = pageSize == 0 ? 0 : (this.getTotal() - 1) / pageSize + 1;
        this.fromIndex = (pageNumber - 1) * pageSize;
        this.toIndex = RangesKt.coerceAtMost((int)(pageNumber * pageSize), (int)this.getTotal());
        this.content = source.subList(this.getFromIndex(), this.getToIndex());
    }

    public /* synthetic */ PageImpl(List list, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n3 & 2) != 0) {
            n = 1;
        }
        if ((n3 & 4) != 0) {
            n2 = 10;
        }
        this(list, n, n2);
    }

    @Override
    public int getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    @Override
    public int getTotalPage() {
        return this.totalPage;
    }

    @Override
    public int getFromIndex() {
        return this.fromIndex;
    }

    @Override
    public int getToIndex() {
        return this.toIndex;
    }

    @Override
    @NotNull
    public List<T> getContent() {
        return this.content;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Page && this.getPageNumber() == ((Page)other).getPageNumber() && this.getPageSize() == ((Page)other).getPageSize() && Intrinsics.areEqual(this.getContent(), ((Page)other).getContent());
    }

    public int hashCode() {
        int result = this.getPageNumber();
        result = 31 * result + this.getPageSize();
        result = 31 * result + ((Object)this.getContent()).hashCode();
        return result;
    }

    public PageImpl() {
        this(null, 0, 0, 7, null);
    }
}

