/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.javafx.extension;

import javafx.animation.Interpolator;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u001a&\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r\u001a&\u0010\b\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r\u001a&\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000f"}, d2={"bezier", "Ljavafx/geometry/Point2D;", "p1", "p2", "p3", "p4", "t", "", "interpolate", "startValue", "endValue", "fraction", "interpolator", "Ljavafx/animation/Interpolator;", "Ljavafx/geometry/Point3D;", "breeze-javafx"})
@JvmName(name="MathExtensions")
public final class MathExtensions {
    public static final double interpolate(double startValue, double endValue, double fraction, @NotNull Interpolator interpolator) {
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        return interpolator.interpolate(startValue, endValue, fraction);
    }

    @NotNull
    public static final Point2D interpolate(@NotNull Point2D startValue, @NotNull Point2D endValue, double fraction, @NotNull Interpolator interpolator) {
        Intrinsics.checkNotNullParameter((Object)startValue, (String)"startValue");
        Intrinsics.checkNotNullParameter((Object)endValue, (String)"endValue");
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        double x = interpolator.interpolate(startValue.getX(), endValue.getX(), fraction);
        double y = interpolator.interpolate(startValue.getY(), endValue.getY(), fraction);
        return new Point2D(x, y);
    }

    @NotNull
    public static final Point3D interpolate(@NotNull Point3D startValue, @NotNull Point3D endValue, double fraction, @NotNull Interpolator interpolator) {
        Intrinsics.checkNotNullParameter((Object)startValue, (String)"startValue");
        Intrinsics.checkNotNullParameter((Object)endValue, (String)"endValue");
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        double x = interpolator.interpolate(startValue.getX(), endValue.getX(), fraction);
        double y = interpolator.interpolate(startValue.getY(), endValue.getY(), fraction);
        double z = interpolator.interpolate(startValue.getZ(), endValue.getZ(), fraction);
        return new Point3D(x, y, z);
    }

    @NotNull
    public static final Point2D bezier(@NotNull Point2D p1, @NotNull Point2D p2, @NotNull Point2D p3, double t) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
        double x = (1.0 - t) * (1.0 - t) * p1.getX() + 2.0 * (1.0 - t) * t * p2.getX() + t * t * p3.getX();
        double y = (1.0 - t) * (1.0 - t) * p1.getY() + 2.0 * (1.0 - t) * t * p2.getY() + t * t * p3.getY();
        return new Point2D(x, y);
    }

    @NotNull
    public static final Point2D bezier(@NotNull Point2D p1, @NotNull Point2D p2, @NotNull Point2D p3, @NotNull Point2D p4, double t) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
        Intrinsics.checkNotNullParameter((Object)p4, (String)"p4");
        double d = 1.0 - t;
        double d2 = 3.0;
        boolean bl = false;
        double d3 = Math.pow(d, d2) * p1.getX();
        d = 1.0 - t;
        d2 = 2.0;
        bl = false;
        double x = d3 + 3.0 * t * Math.pow(d, d2) * p2.getX() + 3.0 * t * t * (1.0 - t) * p3.getX() + t * t * t * p4.getX();
        d2 = 1.0 - t;
        double d4 = 3.0;
        boolean bl2 = false;
        double d5 = Math.pow(d2, d4) * p1.getY();
        d2 = 1.0 - t;
        d4 = 2.0;
        bl2 = false;
        double y = d5 + 3.0 * t * Math.pow(d2, d4) * p2.getY() + 3.0 * t * t * (1.0 - t) * p3.getY() + t * t * t * p4.getY();
        return new Point2D(x, y);
    }
}

