/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.logger.impl;

import icu.windea.breezeframework.logger.LogLevel;
import icu.windea.breezeframework.logger.Logger;
import icu.windea.breezeframework.logger.LoggerConfig;
import icu.windea.breezeframework.logger.impl.SimpleLogger;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B \b\u0016\u0012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\u0012\b\b\u0002\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0015\u001a\u00020\u00052\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017H\u0016J\u0012\u0010\u0015\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016J\u0018\u0010\u001a\u001a\u00020\u00052\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017H\u0016J\u0012\u0010\u001a\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016J\u0018\u0010\u001b\u001a\u00020\u00052\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017H\u0016J\u0012\u0010\u001b\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016J\u0018\u0010\u001c\u001a\u00020\u00052\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017H\u0016J\u0012\u0010\u001c\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016J\u001a\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0002J\u0018\u0010 \u001a\u00020\u00052\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017H\u0016J\u0012\u0010 \u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016J\u0018\u0010!\u001a\u00020\u00052\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017H\u0016J\u0012\u0010!\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016R\u0014\u0010\b\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u001c\u0010\u0013\u001a\n \u000e*\u0004\u0018\u00010\r0\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006\""}, d2={"Licu/windea/breezeframework/logger/impl/SimpleLogger;", "Licu/windea/breezeframework/logger/Logger;", "block", "Lkotlin/Function1;", "Licu/windea/breezeframework/logger/LoggerConfig;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)V", "config", "(Licu/windea/breezeframework/logger/LoggerConfig;)V", "getConfig", "()Licu/windea/breezeframework/logger/LoggerConfig;", "currentClassName", "", "kotlin.jvm.PlatformType", "getCurrentClassName", "()Ljava/lang/String;", "currentClassNameAbbreviation", "getCurrentClassNameAbbreviation", "currentDate", "getCurrentDate", "debug", "lazyMessage", "Lkotlin/Function0;", "", "message", "error", "fatal", "info", "log", "level", "Licu/windea/breezeframework/logger/LogLevel;", "trace", "warn", "breeze-logger"})
public final class SimpleLogger
implements Logger {
    @NotNull
    private final LoggerConfig config;

    @Override
    public void trace(@Nullable Object message) {
        this.log(LogLevel.Trace, message);
    }

    @Override
    public void trace(@NotNull Function0<? extends Object> lazyMessage) {
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        this.log(LogLevel.Trace, lazyMessage.invoke());
    }

    @Override
    public void debug(@Nullable Object message) {
        this.log(LogLevel.Debug, message);
    }

    @Override
    public void debug(@NotNull Function0<? extends Object> lazyMessage) {
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        this.log(LogLevel.Debug, lazyMessage.invoke());
    }

    @Override
    public void info(@Nullable Object message) {
        this.log(LogLevel.Info, message);
    }

    @Override
    public void info(@NotNull Function0<? extends Object> lazyMessage) {
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        this.log(LogLevel.Info, lazyMessage.invoke());
    }

    @Override
    public void warn(@Nullable Object message) {
        this.log(LogLevel.Warn, message);
    }

    @Override
    public void warn(@NotNull Function0<? extends Object> lazyMessage) {
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        this.log(LogLevel.Warn, lazyMessage);
    }

    @Override
    public void error(@Nullable Object message) {
        this.log(LogLevel.Error, message);
    }

    @Override
    public void error(@NotNull Function0<? extends Object> lazyMessage) {
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        this.log(LogLevel.Error, lazyMessage.invoke());
    }

    @Override
    public void fatal(@Nullable Object message) {
        this.log(LogLevel.Fatal, message);
    }

    @Override
    public void fatal(@NotNull Function0<? extends Object> lazyMessage) {
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        this.log(LogLevel.Fatal, lazyMessage.invoke());
    }

    private final void log(LogLevel level, Object message) {
        String string;
        String levelSnippet;
        if (this.getConfig().getMinLogLevel().compareTo((Enum)level) > 0) {
            return;
        }
        String string2 = levelSnippet = this.getConfig().isLevelIncluded() ? level.getText() : null;
        if (this.getConfig().isDateIncluded()) {
            String string3 = this.getCurrentDate();
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            string = '[' + it + ']';
        } else {
            string = null;
        }
        String dateSnippet = string;
        String pathSnippet = this.getConfig().isPathIncluded() && !this.getConfig().isPathAbbreviated() ? this.getCurrentClassName() : (this.getConfig().isPathAbbreviated() ? this.getCurrentClassNameAbbreviation() : null);
        String markersSnippet = CollectionsKt.joinToString$default((Iterable)ArraysKt.filterNotNull((Object[])new String[]{dateSnippet, levelSnippet, pathSnippet}), (CharSequence)" ", (CharSequence)"", (CharSequence)this.getConfig().getDelimiter(), (int)0, null, null, (int)56, null);
        String messageSnippet = String.valueOf(message);
        String logSnippet = markersSnippet + messageSnippet + '\n';
        String string4 = this.getConfig().getOutputPath();
        if (string4 != null) {
            String string5 = string4;
            boolean bl = false;
            boolean bl4 = false;
            String it = string5;
            boolean bl5 = false;
            FilesKt.appendText$default((File)new File(it), (String)logSnippet, null, (int)2, null);
        }
        System.err.print(logSnippet);
    }

    private final String getCurrentDate() {
        return new SimpleDateFormat(this.getConfig().getDateFormat()).format(new Date());
    }

    private final String getCurrentClassName() {
        StackTraceElement stackTraceElement = new Exception().getStackTrace()[3];
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElement, (String)"Exception().stackTrace[3]");
        return stackTraceElement.getClassName();
    }

    private final String getCurrentClassNameAbbreviation() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getCurrentClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentClassName");
        StringBuilder stringBuilder2 = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)string, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null), (CharSequence)".", null, null, (int)0, null, (Function1)currentClassNameAbbreviation.1.INSTANCE, (int)30, null));
        String string2 = this.getCurrentClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"currentClassName");
        String string3 = string2;
        String string4 = this.getCurrentClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"currentClassName");
        int n = StringsKt.lastIndexOf$default((CharSequence)string4, (char)'.', (int)0, (boolean)false, (int)6, null) + 2;
        int n2 = this.getCurrentClassName().length();
        boolean bl = false;
        String string5 = string3;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return stringBuilder2.append(string6).toString();
    }

    @Override
    @NotNull
    public LoggerConfig getConfig() {
        return this.config;
    }

    public SimpleLogger(@NotNull LoggerConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    public /* synthetic */ SimpleLogger(LoggerConfig loggerConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            loggerConfig = new LoggerConfig(false, false, false, false, null, null, null, null, 255, null);
        }
        this(loggerConfig);
    }

    public SimpleLogger() {
        this(null, 1, null);
    }

    public SimpleLogger(@NotNull Function1<? super LoggerConfig, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        LoggerConfig loggerConfig = new LoggerConfig(false, false, false, false, null, null, null, null, 255, null);
        boolean bl = false;
        boolean bl2 = false;
        block.invoke((Object)loggerConfig);
        this(loggerConfig);
    }
}

