/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.serialization.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import icu.windea.breezeframework.serialization.serializer.DelegateSerializer;
import icu.windea.breezeframework.serialization.serializer.JsonSerializer;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J)\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J#\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001b\u0010\u0015\u001a\u00020\u000f\"\u0004\b\u0000\u0010\r2\u0006\u0010\u0016\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Licu/windea/breezeframework/serialization/serializer/GsonSerializer;", "Licu/windea/breezeframework/serialization/serializer/JsonSerializer;", "Licu/windea/breezeframework/serialization/serializer/DelegateSerializer;", "gsonBuilder", "Lcom/google/gson/GsonBuilder;", "(Lcom/google/gson/GsonBuilder;)V", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "getGsonBuilder", "()Lcom/google/gson/GsonBuilder;", "deserialize", "T", "value", "", "type", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "Ljava/lang/reflect/Type;", "(Ljava/lang/String;Ljava/lang/reflect/Type;)Ljava/lang/Object;", "serialize", "target", "(Ljava/lang/Object;)Ljava/lang/String;", "breeze-serialization"})
public final class GsonSerializer
implements JsonSerializer,
DelegateSerializer {
    @NotNull
    private final Gson gson;
    @NotNull
    private final GsonBuilder gsonBuilder;

    @NotNull
    public final Gson getGson() {
        return this.gson;
    }

    @Override
    @NotNull
    public <T> String serialize(T target) {
        String string = this.gson.toJson(target);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(target)");
        return string;
    }

    @Override
    public <T> T deserialize(@NotNull String value, @NotNull Class<T> type) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return (T)this.gson.fromJson(value, type);
    }

    @Override
    public <T> T deserialize(@NotNull String value, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return (T)this.gson.fromJson(value, type);
    }

    @NotNull
    public final GsonBuilder getGsonBuilder() {
        return this.gsonBuilder;
    }

    public GsonSerializer(@NotNull GsonBuilder gsonBuilder) {
        Intrinsics.checkNotNullParameter((Object)gsonBuilder, (String)"gsonBuilder");
        this.gsonBuilder = gsonBuilder;
        Gson gson = this.gsonBuilder.create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"gsonBuilder.create()");
        this.gson = gson;
    }

    public /* synthetic */ GsonSerializer(GsonBuilder gsonBuilder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            gsonBuilder = new GsonBuilder();
        }
        this(gsonBuilder);
    }

    public GsonSerializer() {
        this(null, 1, null);
    }
}

