/*
 * Decompiled with CFR 0.152.
 */
package icu.windea.breezeframework.time.extension;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a\u0015\u0010\u0019\u001a\u00020\u0010*\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u001bH\u0086\u0004\" \u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0001*\u0002H\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\" \u0010\u0005\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0001*\u0002H\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\" \u0010\u0007\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0001*\u0002H\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0004\" \u0010\t\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0001*\u0002H\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0004\" \u0010\u000b\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0001*\u0002H\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0004\" \u0010\r\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0001*\u0002H\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0004\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0012\"\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0014\"\u0015\u0010\u0015\u001a\u00020\u0010*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012\"\u0015\u0010\u0015\u001a\u00020\u0010*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014\"\u0015\u0010\u0016\u001a\u00020\u0010*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012\"\u0015\u0010\u0016\u001a\u00020\u0010*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014\"\u0015\u0010\u0017\u001a\u00020\u0010*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0012\"\u0015\u0010\u0017\u001a\u00020\u0010*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014\"\u0015\u0010\u0018\u001a\u00020\u0010*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012\"\u0015\u0010\u0018\u001a\u00020\u0010*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0014\u00a8\u0006\u001c"}, d2={"atEndOfMonth", "Ljava/time/temporal/Temporal;", "T", "getAtEndOfMonth", "(Ljava/time/temporal/Temporal;)Ljava/time/temporal/Temporal;", "atEndOfYear", "getAtEndOfYear", "atStartOfMonth", "getAtStartOfMonth", "atStartOfNextMonth", "getAtStartOfNextMonth", "atStartOfNextYear", "getAtStartOfNextYear", "atStartOfYear", "getAtStartOfYear", "isInFuture", "", "Ljava/time/LocalDate;", "(Ljava/time/LocalDate;)Z", "Ljava/time/LocalDateTime;", "(Ljava/time/LocalDateTime;)Z", "isInPast", "isToday", "isTomorrow", "isYesterday", "supports", "temporalUnit", "Ljava/time/temporal/TemporalUnit;", "breeze-time"})
@JvmName(name="TemporalExtensions")
public final class TemporalExtensions {
    @NotNull
    public static final <T extends Temporal> Temporal getAtStartOfMonth(@NotNull T $this$atStartOfMonth) {
        int $i$f$getAtStartOfMonth = 0;
        Intrinsics.checkNotNullParameter($this$atStartOfMonth, (String)"$this$atStartOfMonth");
        Temporal temporal = $this$atStartOfMonth.with(TemporalAdjusters.firstDayOfMonth());
        Intrinsics.checkNotNullExpressionValue((Object)temporal, (String)"with(TemporalAdjusters.firstDayOfMonth())");
        return temporal;
    }

    @NotNull
    public static final <T extends Temporal> Temporal getAtEndOfMonth(@NotNull T $this$atEndOfMonth) {
        int $i$f$getAtEndOfMonth = 0;
        Intrinsics.checkNotNullParameter($this$atEndOfMonth, (String)"$this$atEndOfMonth");
        Temporal temporal = $this$atEndOfMonth.with(TemporalAdjusters.lastDayOfMonth());
        Intrinsics.checkNotNullExpressionValue((Object)temporal, (String)"with(TemporalAdjusters.lastDayOfMonth())");
        return temporal;
    }

    @NotNull
    public static final <T extends Temporal> Temporal getAtStartOfNextMonth(@NotNull T $this$atStartOfNextMonth) {
        int $i$f$getAtStartOfNextMonth = 0;
        Intrinsics.checkNotNullParameter($this$atStartOfNextMonth, (String)"$this$atStartOfNextMonth");
        Temporal temporal = $this$atStartOfNextMonth.with(TemporalAdjusters.firstDayOfNextMonth());
        Intrinsics.checkNotNullExpressionValue((Object)temporal, (String)"with(TemporalAdjusters.firstDayOfNextMonth())");
        return temporal;
    }

    @NotNull
    public static final <T extends Temporal> Temporal getAtStartOfYear(@NotNull T $this$atStartOfYear) {
        int $i$f$getAtStartOfYear = 0;
        Intrinsics.checkNotNullParameter($this$atStartOfYear, (String)"$this$atStartOfYear");
        Temporal temporal = $this$atStartOfYear.with(TemporalAdjusters.firstDayOfYear());
        Intrinsics.checkNotNullExpressionValue((Object)temporal, (String)"with(TemporalAdjusters.firstDayOfYear())");
        return temporal;
    }

    @NotNull
    public static final <T extends Temporal> Temporal getAtEndOfYear(@NotNull T $this$atEndOfYear) {
        int $i$f$getAtEndOfYear = 0;
        Intrinsics.checkNotNullParameter($this$atEndOfYear, (String)"$this$atEndOfYear");
        Temporal temporal = $this$atEndOfYear.with(TemporalAdjusters.lastDayOfYear());
        Intrinsics.checkNotNullExpressionValue((Object)temporal, (String)"with(TemporalAdjusters.lastDayOfYear())");
        return temporal;
    }

    @NotNull
    public static final <T extends Temporal> Temporal getAtStartOfNextYear(@NotNull T $this$atStartOfNextYear) {
        int $i$f$getAtStartOfNextYear = 0;
        Intrinsics.checkNotNullParameter($this$atStartOfNextYear, (String)"$this$atStartOfNextYear");
        Temporal temporal = $this$atStartOfNextYear.with(TemporalAdjusters.firstDayOfNextYear());
        Intrinsics.checkNotNullExpressionValue((Object)temporal, (String)"with(TemporalAdjusters.firstDayOfNextYear())");
        return temporal;
    }

    public static final boolean isToday(@NotNull LocalDate $this$isToday) {
        Intrinsics.checkNotNullParameter((Object)$this$isToday, (String)"$this$isToday");
        LocalDate localDate2 = LocalDate.now();
        boolean bl = false;
        boolean bl2 = false;
        LocalDate it = localDate2;
        boolean bl3 = false;
        int n = $this$isToday.getYear();
        LocalDate localDate3 = it;
        Intrinsics.checkNotNullExpressionValue((Object)localDate3, (String)"it");
        return n == localDate3.getYear() && $this$isToday.getDayOfYear() == it.getDayOfYear();
    }

    public static final boolean isYesterday(@NotNull LocalDate $this$isYesterday) {
        Intrinsics.checkNotNullParameter((Object)$this$isYesterday, (String)"$this$isYesterday");
        LocalDate localDate2 = LocalDate.now();
        boolean bl = false;
        boolean bl2 = false;
        LocalDate it = localDate2;
        boolean bl3 = false;
        int n = $this$isYesterday.getYear();
        LocalDate localDate3 = it;
        Intrinsics.checkNotNullExpressionValue((Object)localDate3, (String)"it");
        return n == localDate3.getYear() && $this$isYesterday.getDayOfYear() == it.getDayOfYear() - 1;
    }

    public static final boolean isTomorrow(@NotNull LocalDate $this$isTomorrow) {
        Intrinsics.checkNotNullParameter((Object)$this$isTomorrow, (String)"$this$isTomorrow");
        LocalDate localDate2 = LocalDate.now();
        boolean bl = false;
        boolean bl2 = false;
        LocalDate it = localDate2;
        boolean bl3 = false;
        int n = $this$isTomorrow.getYear();
        LocalDate localDate3 = it;
        Intrinsics.checkNotNullExpressionValue((Object)localDate3, (String)"it");
        return n == localDate3.getYear() && $this$isTomorrow.getDayOfYear() == it.getDayOfYear() + 1;
    }

    public static final boolean isInPast(@NotNull LocalDate $this$isInPast) {
        Intrinsics.checkNotNullParameter((Object)$this$isInPast, (String)"$this$isInPast");
        return $this$isInPast.compareTo(LocalDate.now()) < 0;
    }

    public static final boolean isInFuture(@NotNull LocalDate $this$isInFuture) {
        Intrinsics.checkNotNullParameter((Object)$this$isInFuture, (String)"$this$isInFuture");
        return $this$isInFuture.compareTo(LocalDate.now()) > 0;
    }

    public static final boolean isToday(@NotNull LocalDateTime $this$isToday) {
        Intrinsics.checkNotNullParameter((Object)$this$isToday, (String)"$this$isToday");
        LocalDateTime localDateTime2 = LocalDateTime.now();
        boolean bl = false;
        boolean bl2 = false;
        LocalDateTime it = localDateTime2;
        boolean bl3 = false;
        int n = $this$isToday.getYear();
        LocalDateTime localDateTime3 = it;
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"it");
        return n == localDateTime3.getYear() && $this$isToday.getDayOfYear() == it.getDayOfYear();
    }

    public static final boolean isYesterday(@NotNull LocalDateTime $this$isYesterday) {
        Intrinsics.checkNotNullParameter((Object)$this$isYesterday, (String)"$this$isYesterday");
        LocalDateTime localDateTime2 = LocalDateTime.now();
        boolean bl = false;
        boolean bl2 = false;
        LocalDateTime it = localDateTime2;
        boolean bl3 = false;
        int n = $this$isYesterday.getYear();
        LocalDateTime localDateTime3 = it;
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"it");
        return n == localDateTime3.getYear() && $this$isYesterday.getDayOfYear() == it.getDayOfYear() - 1;
    }

    public static final boolean isTomorrow(@NotNull LocalDateTime $this$isTomorrow) {
        Intrinsics.checkNotNullParameter((Object)$this$isTomorrow, (String)"$this$isTomorrow");
        LocalDateTime localDateTime2 = LocalDateTime.now();
        boolean bl = false;
        boolean bl2 = false;
        LocalDateTime it = localDateTime2;
        boolean bl3 = false;
        int n = $this$isTomorrow.getYear();
        LocalDateTime localDateTime3 = it;
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime3, (String)"it");
        return n == localDateTime3.getYear() && $this$isTomorrow.getDayOfYear() == it.getDayOfYear() + 1;
    }

    public static final boolean isInPast(@NotNull LocalDateTime $this$isInPast) {
        Intrinsics.checkNotNullParameter((Object)$this$isInPast, (String)"$this$isInPast");
        return $this$isInPast.compareTo(LocalDateTime.now()) < 0;
    }

    public static final boolean isInFuture(@NotNull LocalDateTime $this$isInFuture) {
        Intrinsics.checkNotNullParameter((Object)$this$isInFuture, (String)"$this$isInFuture");
        return $this$isInFuture.compareTo(LocalDateTime.now()) > 0;
    }

    public static final boolean supports(@NotNull Temporal $this$supports, @NotNull TemporalUnit temporalUnit) {
        Intrinsics.checkNotNullParameter((Object)$this$supports, (String)"$this$supports");
        Intrinsics.checkNotNullParameter((Object)temporalUnit, (String)"temporalUnit");
        return $this$supports.isSupported(temporalUnit);
    }
}

