package icu.wuhufly.impl

import icu.wuhufly.Create
import org.apache.spark.sql.SparkSession

import java.util.UUID

class CreateImpl extends Create {
  override def getSpark(setMaster: Boolean): SparkSession = {
    val builder: SparkSession.Builder = SparkSession.builder().enableHiveSupport()

    if (setMaster) builder.master("local[*]")

    val spark: SparkSession = builder.getOrCreate()
    spark.udf.register("uuid", () => UUID.randomUUID().toString)
    spark
  }
}
