package icu.wuhufly.dwd

import icu.wuhufly.SparkHandler
import org.apache.spark.SparkContext
import org.apache.spark.sql.types.{DateType, TimestampType}
import org.apache.spark.sql.{DataFrame, SparkSession}

object CreateTable00 {
  def main(args: Array[String]): Unit = {
    val handler: SparkHandler = SparkHandler.of()
    val spark: SparkSession = handler.getSpark()
    val sc: SparkContext = spark.sparkContext
    import org.apache.spark.sql.functions._
    import spark.implicits._

    Array("ChangeRecord","BaseMachine","MachineData","ProduceRecord", "EnvironmentData")
      .zip(Array("fact_change_record","dim_machine","fact_machine_data","fact_produce_record","fact_environment_data"))
      .foreach(s => {
        var df: DataFrame = handler.readFromHDFS(s._1.toLowerCase, spark)
          .withColumn("dwd_insert_time", current_timestamp())
          .withColumn("dwd_insert_user", lit("user1"))
          .withColumn("dwd_modify_time", current_timestamp())
          .withColumn("dwd_modify_user", lit("user1"))

        df.schema.fields.filter(s => s.dataType.equals(TimestampType) || s.dataType.equals(DateType))
          .map(_.name)
          .foreach(s => df = df.withColumn(s, date_format(col(s), "yyyy-MM-dd HH:mm:ss")))

        s._1 match {
          case "ChangeRecord" => {
            handler.writeIntoHDFS(
              s._2, df, "ChangeID,ChangeMachineID", "ChangeEndTime", dbName = "hudi_gy_dwd"
            )
          }
          case "EnvironmentData" => {
            df = df.withColumn("InPutTime", $"InPutTime".cast(TimestampType))
              .withColumn("InPutTime", date_format($"InPutTime", "yyyy-MM-dd HH:mm:ss"))
            handler.writeIntoHDFS(
              s._2, df, "InPutTime", "EnvoId", dbName = "hudi_gy_dwd"
            )
          }
          case "BaseMachine" => {
            handler.writeIntoHDFS(
              s._2, df, "BaseMachineID", "MachineAddDate", dbName = "hudi_gy_dwd"
            )
          }
          case "ProduceRecord" => {
            handler.writeIntoHDFS(
              s._2, df, "ProduceRecordID,ProduceMachineID", "ProduceCodeEndTime", dbName = "hudi_gy_dwd"
            )
          }
          case "MachineData" => {
            handler.writeIntoHDFS(
              s._2, df, "MachineRecordID", "MachineRecordDate", dbName = "hudi_gy_dwd"
            )
          }
          case _ => {}
        }
      })

    sc.stop()
  }
}
