package icu.wuhufly.dws

import icu.wuhufly.SparkHandler
import org.apache.spark.SparkContext
import org.apache.spark.sql.{DataFrame, SparkSession}

object accumulate_standby13 {
  def main(args: Array[String]): Unit = {
    val handler: SparkHandler = SparkHandler.of()
    val spark: SparkSession = handler.getSpark()
    val sc: SparkContext = spark.sparkContext
    spark.sql("use hudi_gy_dwd")
    import spark.implicits._

    spark.createDataset(
      sc.makeRDD((0 until 24))
    )
      .toDF("hour")
      .createOrReplaceTempView("hour_tbl")

    spark.sql(
      """
        |select start_date, start_hour, sum(duration) as duration
        |from (
        | select cast(to_timestamp(ChangeStartTime, 'yyyy-MM-dd HH:mm:ss') as long) -
        |     cast(to_timestamp(ChangeEndTime, 'yyyy-MM-dd HH:mm:ss') as long) as duration,
        |    date_format(to_timestamp(ChangeStartTime, 'yyyy-MM-dd HH:mm:ss'), 'yyyy-MM-dd') as start_date,
        |    hour(to_timestamp(ChangeStartTime, 'yyyy-MM-dd HH:mm:ss')) as start_hour
        |  from fact_change_record
        |    where ChangeStartTime >= '2021-10-12 00:00:00'
        |      and ChangeRecordState = '待机'
        |) t1
        |  group by start_date, start_hour
        |""".stripMargin)
      .createOrReplaceTempView("temp")

    val df: DataFrame = spark.sql(
      """
        |select *, sum(hour_add_standby) over(partition by start_date order by start_hour) as day_agg_standby
        |from (
        |select t1.start_date, t1.hour as start_hour, sum(ifNull(t2.duration, 0)) as hour_add_standby
        |from (
        | select t1.start_date, t2.hour
        |  from (select distinct start_date from temp) t1
        |  join hour_tbl t2
        |) t1
        |  left join temp t2
        |    on t1.start_date = t2.start_date and t1.hour = t2.start_hour
        |  group by t1.start_date, t1.hour
        |) t1
        |""".stripMargin)

    handler.writeIntoMysql(
      "accumulate_standby", df,
    )

    sc.stop()
  }
}
