package icu.wuhufly.dws

import icu.wuhufly.SparkHandler
import org.apache.spark.SparkContext
import org.apache.spark.sql.{DataFrame, SparkSession}

object machine_data_total_time07 {
  def main(args: Array[String]): Unit = {
    val handler: SparkHandler = SparkHandler.of()
    val spark: SparkSession = handler.getSpark()
    val sc: SparkContext = spark.sparkContext
    spark.sql("use hudi_gy_dwd")

    val df: DataFrame = spark.sql(
      """
        |select machine_id, machine_record_date, sum(total_time) as total_time
        |from (
        | select machine_id, date_format(ts, 'yyyy-MM-dd') as machine_record_date,
        |   cast(next_ts as long) - cast(ts as long) as total_time
        |  from (
        |   select *, lead(ts) over(partition by machine_id order by ts) as next_ts
        |    from (
        |     select MachineID as machine_id, MachineRecordState, to_timestamp(MachineRecordDate, 'yyyy-MM-dd HH:mm:ss') as ts
        |      from fact_machine_data
        |  ) t1
        | ) t1
        |  where MachineRecordState = '运行'
        |) t1
        |  group by machine_id, machine_record_date
        |""".stripMargin)

    handler.writeIntoHDFS(
      "machine_data_total_time", df, "machine_record_date", "total_time", "machine_id", "hudi_gy_dws"
    )

    sc.stop()
  }
}
