package icu.wuhufly.dws

import icu.wuhufly.SparkHandler
import org.apache.spark.SparkContext
import org.apache.spark.sql.{DataFrame, SparkSession}

object machine_data_total_time_top312 {
  def main(args: Array[String]): Unit = {
    val handler: SparkHandler = SparkHandler.of()
    val spark: SparkSession = handler.getSpark()
    val sc: SparkContext = spark.sparkContext
    spark.sql("use hudi_gy_dws")

    spark.sql(
      """
        |select *
        |from (
        | select machine_id, machine_record_date as date_day, total_time,
        |    dense_rank() over(partition by machine_record_date order by total_time desc) as rn
        |  from machine_data_total_time
        |) t1
        |  where rn <= 3
        |""".stripMargin)
      .createOrReplaceTempView("temp")

    val df: DataFrame = spark.sql(
      """
        |select t1.date_day,
        |  t1.machine_id as first_id,
        |  t2.machine_id as second_id,
        |  t3.machine_id as tertiary_id,
        |  t1.total_time as first_time,
        |  t2.total_time as second_time,
        |  t3.total_time as tertiary_time
        |    from (select * from temp where rn = 1) t1
        |    left join (select * from temp where rn = 2) t2
        |    left join (select * from temp where rn = 3) t3
        |      on t1.date_day = t2.date_day
        |      and t1.date_day = t3.date_day
        |""".stripMargin)

    handler.writeIntoMysql(
      "machine_state_time", df
    )

    sc.stop()
  }
}
