package icu.wuhufly.dws

import icu.wuhufly.SparkHandler
import org.apache.spark.SparkContext
import org.apache.spark.sql.{DataFrame, SparkSession}

object machine_humidityAVG_compare11 {
  def main(args: Array[String]): Unit = {
    val handler: SparkHandler = SparkHandler.of()
    val spark: SparkSession = handler.getSpark()
    val sc: SparkContext = spark.sparkContext
    spark.sql("use hudi_gy_dwd")

    val df: DataFrame = spark.sql(
      """
        |select base_id, machine_avg, factory_avg,
        |  case when machine_avg > factory_avg then '高'
        |    when machine_avg = factory_avg then '相同'
        |    else '低' end as comparison,
        |    env_date_year, env_date_month
        |from (
        |select base_id, avg(Humidity) over(partition by base_id,env_date_year,env_date_month) as machine_avg,
        |  avg(Humidity) over(partition by MachineFactory, env_date_year, env_date_month) as factory_avg,
        |  env_date_year, env_date_month
        |from (
        |select year(to_timestamp(t1.InPutTime, 'yyyy-MM-dd HH:mm:ss')) as env_date_year,
        |  month(to_timestamp(t1.InPutTime, 'yyyy-MM-dd HH:mm:ss')) as env_date_month,
        |  t1.Humidity, t1.BaseID as base_id, t2.MachineFactory
        |    from fact_environment_data t1
        |    join dim_machine t2
        |      on t1.BaseID = t2.BaseMachineID
        |) t1
        |) t1
        |""".stripMargin)

    handler.writeIntoMysql(
      "machine_runningAVG_compare", df
    )

    sc.stop()
  }
}
