package icu.wuhufly.dws

import icu.wuhufly.SparkHandler
import org.apache.spark.SparkContext
import org.apache.spark.sql.{DataFrame, SparkSession}

object machine_produce_per_avgtime03 {
  def main(args: Array[String]): Unit = {
    val handler: SparkHandler = SparkHandler.of()
    val spark: SparkSession = handler.getSpark()
    val sc: SparkContext = spark.sparkContext
    spark.sql("use hudi_gy_dwd")

    val df: DataFrame = spark.sql(
      """
        |select *
        |from (
        |select *, cast(avg(producetime) over(partition by produce_machine_id) as int) as produce_per_avgtime
        |from (
        | select ProduceRecordID as produce_record_id, ProduceMachineID as produce_machine_id,
        |  cast(to_timestamp(ProduceCodeEndTime, 'yyyy-MM-dd HH:mm:ss') as long) -
        |    cast(to_timestamp(ProduceCodeStartTime, 'yyyy-MM-dd HH:mm:ss') as long) as producetime
        |    from fact_produce_record
        |     where ProduceCodeEndTime != cast('1900-01-01 00:00:00.0' as timestamp)
        |) t1
        |) t1
        |  where producetime > produce_per_avgtime
        |""".stripMargin)

    handler.writeIntoCK(
      "machine_produce_per_avgtime", df, "produce_record_id"
    )

    sc.stop()
  }
}
