package icu.wuhufly.dws

import icu.wuhufly.SparkHandler
import org.apache.spark.SparkContext
import org.apache.spark.sql.{DataFrame, SparkSession}

object machine_produce_timetop210 {
  def main(args: Array[String]): Unit = {
    val handler: SparkHandler = SparkHandler.of()
    val spark: SparkSession = handler.getSpark()
    val sc: SparkContext = spark.sparkContext
    spark.sql("use hudi_gy_dws")

    spark.sql(
      """
        |select *
        |from (
        |select produce_machine_id as machine_id, producetime,
        |   row_number() over(partition by produce_machine_id order by producetime desc) as rn
        |  from machine_produce_per_avgtime
        |) t1
        |  where rn <= 2
        |""".stripMargin)
      .createOrReplaceTempView("temp")

    val df: DataFrame = spark.sql(
      """
        |select t1.machine_id,
        |  t1.producetime as first_time, t2.producetime as second_time
        |    from (select * from temp where rn = 1) t1
        |    left join (select * from temp where rn = 2) t2
        |      on t1.machine_id = t2.machine_id
        |""".stripMargin)

    handler.writeIntoCK(
      "machine_produce_timetop2", df, "machine_id"
    )

    sc.stop()
  }
}
