package icu.wuhufly.dws

import icu.wuhufly.SparkHandler
import org.apache.spark.SparkContext
import org.apache.spark.sql.{DataFrame, SparkSession}

object machine_running_compare04 {
  def main(args: Array[String]): Unit = {
    val handler: SparkHandler = SparkHandler.of()
    val spark: SparkSession = handler.getSpark()
    val sc: SparkContext = spark.sparkContext
    spark.sql("use hudi_gy_dwd")
    val df: DataFrame = spark.sql(
      """
        |select start_month, machine_factory,
        |  case when factory_avg > company_avg then '高'
        |    when factory_avg = company_avg then '相同'
        |    else '低' end as comparison,
        |    factory_avg, company_avg
        |from (
        |select distinct start_month, machine_factory,
        |  avg(duration_time) over(partition by start_month, machine_factory) as factory_avg,
        |  avg(duration_time) over(partition by start_month) as company_avg
        |from (
        | select machine_id, sum(duration_time) as duration_time, machine_factory, date_format(ts, 'yyyy-MM') as start_month
        |  from (
        |   select t1.ChangeMachineID as machine_id,
        |     cast(to_timestamp(t1.ChangeEndTime, 'yyyy-MM-dd HH:mm:ss') as long) -
        |       cast(to_timestamp(t1.ChangeStartTime, 'yyyy-MM-dd HH:mm:ss') as long) as duration_time,
        |       to_timestamp(t1.ChangeStartTime, 'yyyy-MM-dd HH:mm:ss') as ts,
        |      t2.MachineFactory as machine_factory
        |    from fact_change_record t1
        |    join dim_machine t2
        |      on t1.ChangeMachineID = t2.BaseMachineID
        |       where t1.ChangeEndTime is not null and t1.ChangeRecordState = '运行'
        |) t1
        |  group by machine_id, machine_factory, date_format(ts, 'yyyy-MM')
        |) t1
        |) t1
        |""".stripMargin)

    handler.writeIntoMysql(
      "machine_running_compare", df,
    )

    sc.stop()
  }
}
