package icu.wuhufly.dws

import icu.wuhufly.SparkHandler
import org.apache.spark.SparkContext
import org.apache.spark.sql.{DataFrame, SparkSession}

object machine_state_time01 {
  def main(args: Array[String]): Unit = {
    val handler: SparkHandler = SparkHandler.of()
    val spark: SparkSession = handler.getSpark()
    val sc: SparkContext = spark.sparkContext
    spark.sql("use hudi_gy_dwd")
    val df: DataFrame = spark.sql(
      """
        |select machine_id, change_record_state, sum(duration_time) as duration_time,
        |  year(ts) as year, month(ts) as month
        |from (
        |  select ChangeRecordState as change_record_state, ChangeMachineID as machine_id,
        |    cast(to_timestamp(ChangeEndTime, 'yyyy-MM-dd HH:mm:ss') as long) -
        |      cast(to_timestamp(ChangeStartTime, 'yyyy-MM-dd HH:mm:ss') as long) as duration_time,
        |      to_timestamp(ChangeStartTime, 'yyyy-MM-dd HH:mm:ss') as ts
        |  from fact_change_record
        |    where ChangeEndTime is not null
        |) t1
        |  group by machine_id, change_record_state, year(ts), month(ts)
        |""".stripMargin)

    handler.writeIntoCK(
      "machine_state_time", df, "machine_id"
    )


    sc.stop()
  }
}
