package icu.wuhufly.dws

import icu.wuhufly.SparkHandler
import org.apache.spark.SparkContext
import org.apache.spark.sql.{DataFrame, SparkSession}

object recent_state05 {
  def main(args: Array[String]): Unit = {
    val handler: SparkHandler = SparkHandler.of()
    val spark: SparkSession = handler.getSpark()
    val sc: SparkContext = spark.sparkContext
    spark.sql("use hudi_gy_dwd")

    spark.sql(
      """
        |select ChangeMachineID as machine_id, ChangeRecordState as record_state,
        |    ChangeStartTime as change_start_time, ChangeEndTime as change_end_time,
        |    row_number() over(partition by ChangeMachineID order by ChangeStartTime desc) as rn
        |  from fact_change_record
        |""".stripMargin)
      .createOrReplaceTempView("temp")

    val df: DataFrame = spark.sql(
      """
        |select t1.machine_id,
        |  ifNull(t2.record_state, t1.record_state) as record_state,
        |  ifNull(t2.change_start_time, t1.change_start_time) as change_start_time,
        |  ifNull(t2.change_end_time, t1.change_end_time) as change_end_time
        |    from (select * from temp where rn = 1) t1
        |    left join (select * from temp where rn = 2) t2
        |      using (machine_id)
        |""".stripMargin)

    handler.writeIntoMysql(
      "recent_state", df,
    )

    sc.stop()
  }
}
