package icu.wuhufly.dws

import icu.wuhufly.SparkHandler
import org.apache.spark.SparkContext
import org.apache.spark.sql.{DataFrame, SparkSession}

object slide_window_runnning14 {
  def main(args: Array[String]): Unit = {
    val handler: SparkHandler = SparkHandler.of()
    val spark: SparkSession = handler.getSpark()
    val sc: SparkContext = spark.sparkContext
    spark.sql("use hudi_gy_dwd")
    import spark.implicits._

    spark.sql(
      """
        |select state_start_time, sum(duration) as duration
        |from (
        | select cast(to_timestamp(ChangeEndTime, 'yyyy-MM-dd HH:mm:ss') as long) -
        |     cast(to_timestamp(ChangeStartTime, 'yyyy-MM-dd HH:mm:ss') as long) as duration,
        |    date_format(to_timestamp(ChangeStartTime, 'yyyy-MM-dd HH:mm:ss'), 'yyyy-MM-dd_HH') as state_start_time
        |  from fact_change_record
        |    where ChangeStartTime >= '2021-10-13 00:00:00'
        |      and ChangeRecordState = '运行'
        |) t1
        |  group by state_start_time
        |""".stripMargin)
      .createOrReplaceTempView("temp")

//    spark.sql("select * from temp").show(5, false)

    val df: DataFrame = spark.sql(
      """
        |select state_start_time, window_sum, window_sum / 3 as window_avg
        |from (
        |select t1.state_start_time, sum(ifNull(t2.duration, 0)) as window_sum,
        |  count(1) as counting
        |  from (select distinct state_start_time from temp) t1
        |   left join temp t2
        |     on (
        |        cast(to_timestamp(t1.state_start_time, 'yyyy-MM-dd_HH') as long) -
        |        cast(to_timestamp(t2.state_start_time, 'yyyy-MM-dd_HH') as long) < 10800
        |        )
        |     and (
        |          cast(to_timestamp(t1.state_start_time, 'yyyy-MM-dd_HH') as long) >=
        |          cast(to_timestamp(t2.state_start_time, 'yyyy-MM-dd_HH') as long)
        |        )
        |    group by t1.state_start_time
        |) t1
        |  where counting = 3
        |""".stripMargin)

//    df.show(5, false)

    handler.writeIntoMysql(
      "slide_window_runnning", df
    )

    sc.stop()
  }
}
