package icu.wuhufly.ods

import icu.wuhufly.SparkHandler
import org.apache.spark.SparkContext
import org.apache.spark.sql.{DataFrame, SparkSession}

object CreateTable00 {
  def main(args: Array[String]): Unit = {
    val handler: SparkHandler = SparkHandler.of()
    val spark: SparkSession = handler.getSpark()
    val sc: SparkContext = spark.sparkContext
    import spark.implicits._
    import org.apache.spark.sql.functions._

    Array("ChangeRecord","BaseMachine","MachineData","ProduceRecord", "EnvironmentData")
      .foreach(s => {
        val df: DataFrame = handler.readFromMysql(s, spark)
          .withColumn("etldate", date_format(date_sub(current_timestamp(), 1), "yyyyMMdd"))

        s match {
          case "ChangeRecord" => {
            handler.writeIntoHDFS(
              s.toLowerCase, df, "ChangeID,ChangeMachineID", "ChangeEndTime",
            )
          }
          case "EnvironmentData" => {
            handler.writeIntoHDFS(
              s.toLowerCase, df, "InPutTime", "EnvoId",
            )
          }
          case "BaseMachine" => {
            handler.writeIntoHDFS(
              s.toLowerCase, df, "BaseMachineID", "MachineAddDate",
            )
          }
          case "ProduceRecord" => {
            handler.writeIntoHDFS(
              s.toLowerCase, df.drop("ProducePrgCode"), "ProduceRecordID,ProduceMachineID", "ProduceCodeEndTime",
            )
          }
          case "MachineData" => {
            handler.writeIntoHDFS(
              s.toLowerCase, df, "MachineRecordID", "MachineRecordDate",
            )
          }
          case _ => {}
        }
      })

    sc.stop()
  }
}
