/*
 * Decompiled with CFR 0.152.
 */
package icu.wuhufly.features;

import icu.wuhufly.SparkHandler;
import icu.wuhufly.SparkHandler$;
import org.apache.spark.SparkContext;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.classification.RandomForestClassifier;
import org.apache.spark.ml.evaluation.BinaryClassificationEvaluator;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.feature.Normalizer;
import org.apache.spark.ml.feature.OneHotEncoder;
import org.apache.spark.ml.feature.StandardScaler;
import org.apache.spark.ml.feature.VectorAssembler;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.tuning.CrossValidator;
import org.apache.spark.ml.tuning.ParamGridBuilder;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;

public final class Pred02$ {
    public static Pred02$ MODULE$;

    static {
        new Pred02$();
    }

    public void main(String[] args) {
        SparkHandler handler = SparkHandler$.MODULE$.of();
        SparkSession spark = handler.getSpark(handler.getSpark$default$1());
        SparkContext sc = spark.sparkContext();
        spark.sql("use hudi_gy_dwd");
        Dataset[] datasetArray = handler.readFromHDFS("fact_machine_learning_data", spark, "hudi_gy_dwd").randomSplit(new double[]{0.8, 0.2}, 42L);
        Option option = Array$.MODULE$.unapplySeq((Object)datasetArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)datasetArray);
        }
        Dataset train = (Dataset)((SeqLike)option.get()).apply(0);
        Dataset test = (Dataset)((SeqLike)option.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)train, (Object)test);
        Tuple2 tuple22 = tuple2;
        Dataset train2 = (Dataset)tuple22._1();
        Dataset test2 = (Dataset)tuple22._2();
        RandomForestClassifier rfc = (RandomForestClassifier)new RandomForestClassifier().setSeed(42L).setLabelCol("machine_record_state").setFeaturesCol("features");
        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{new VectorAssembler().setInputCols((String[])((Object[])new String[]{"machine_record_mainshaft_speed", "machine_record_mainshaft_multiplerate", "machine_record_mainshaft_load", "machine_record_feed_speed", "machine_record_feed_multiplerate", "machine_record_pmc_code", "machine_record_circle_time", "machine_record_run_time", "machine_record_effective_shaft", "machine_record_amount_process", "machine_record_use_memory", "machine_record_free_memory", "machine_record_amount_use_code", "machine_record_amount_free_code"})).setOutputCol("ass_features"), new OneHotEncoder().setInputCol("machine_id").setOutputCol("ohe1"), new StandardScaler().setInputCol("ass_features").setOutputCol("std_features"), new Normalizer().setInputCol("std_features").setOutputCol("features"), rfc}));
        BinaryClassificationEvaluator evaluator = new BinaryClassificationEvaluator().setLabelCol("machine_record_state");
        ParamMap[] paramMaps = new ParamGridBuilder().addGrid(rfc.maxBins(), new int[]{32, 48}).addGrid(rfc.numTrees(), new int[]{20, 40}).addGrid(rfc.maxDepth(), new int[]{5, 10}).build();
        Dataset resDF = new CrossValidator().setSeed(42L).setNumFolds(3).setEvaluator((Evaluator)evaluator).setEstimator((Estimator)pipeline).setParallelism(6).setEstimatorParamMaps(paramMaps).fit(train2).transform(test2).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"machine_record_id", "prediction as machine_record_state"}));
        handler.writeIntoMysql("ml_result", (Dataset<Row>)resDF, handler.writeIntoMysql$default$3(), handler.writeIntoMysql$default$4());
        sc.stop();
    }

    private Pred02$() {
        MODULE$ = this;
    }
}

