/*
 * Decompiled with CFR 0.152.
 */
package icu.wwj.camel.component.rocketmq;

import icu.wwj.camel.component.rocketmq.RocketMQEndpoint;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQComponent
extends DefaultComponent {
    private final Logger logger = LoggerFactory.getLogger(RocketMQComponent.class);
    @Metadata(required=true)
    private String topicName;
    @Metadata(label="producer")
    private String producerGroup;
    @Metadata(label="consumer")
    private String consumerGroup;
    @Metadata(label="consumer", defaultValue="*")
    private String subscribeTags = "*";
    @Metadata(label="common", defaultValue="")
    private String sendTag = "";
    @Metadata(label="common", defaultValue="localhost:9876")
    private String namesrvAddr = "localhost:9876";
    @Metadata(label="producer")
    private String replyToTopic;
    @Metadata(label="producer")
    private String replyToConsumerGroup;
    @Metadata(label="advance", defaultValue="10000")
    private Long requestTimeout = 10000L;
    @Metadata(label="advance", defaultValue="1000")
    private Long requestTimeoutCheckerInterval = 1000L;
    @Metadata(label="producer", defaultValue="false")
    private Boolean waitForSendResult = false;
    @Metadata(label="accessKey")
    private String accessKey;
    @Metadata(label="secretKey")
    private String secretKey;

    protected RocketMQEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        RocketMQEndpoint endpoint = new RocketMQEndpoint(uri, this);
        endpoint.setTopicName(remaining);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getNamesrvAddr() == null) {
            endpoint.setNamesrvAddr("localhost:9876");
        }
        return endpoint;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getSubscribeTags() {
        return this.subscribeTags;
    }

    public void setSubscribeTags(String subscribeTags) {
        this.subscribeTags = subscribeTags;
    }

    public String getSendTag() {
        return this.sendTag;
    }

    public void setSendTag(String sendTag) {
        this.sendTag = sendTag;
    }

    public String getNamesrvAddr() {
        return this.namesrvAddr;
    }

    public void setNamesrvAddr(String namesrvAddr) {
        this.namesrvAddr = namesrvAddr;
    }

    public String getProducerGroup() {
        return this.producerGroup;
    }

    public void setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public String getReplyToTopic() {
        return this.replyToTopic;
    }

    public void setReplyToTopic(String replyToTopic) {
        this.replyToTopic = replyToTopic;
    }

    public String getReplyToConsumerGroup() {
        return this.replyToConsumerGroup;
    }

    public void setReplyToConsumerGroup(String replyToConsumerGroup) {
        this.replyToConsumerGroup = replyToConsumerGroup;
    }

    public Long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public Long getRequestTimeoutCheckerInterval() {
        return this.requestTimeoutCheckerInterval;
    }

    public void setRequestTimeoutCheckerInterval(Long requestTimeoutCheckerInterval) {
        this.requestTimeoutCheckerInterval = requestTimeoutCheckerInterval;
    }

    public Boolean getWaitForSendResult() {
        return this.waitForSendResult;
    }

    public void setWaitForSendResult(Boolean waitForSendResult) {
        this.waitForSendResult = waitForSendResult;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }
}

