/*
 * Decompiled with CFR 0.152.
 */
package icu.wwj.camel.component.rocketmq;

import icu.wwj.camel.component.rocketmq.AclUtils;
import icu.wwj.camel.component.rocketmq.RocketMQEndpoint;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.support.DefaultConsumer;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQConsumer
extends DefaultConsumer
implements Suspendable {
    private final Logger logger = LoggerFactory.getLogger(RocketMQConsumer.class);
    private final RocketMQEndpoint endpoint;
    private DefaultMQPushConsumer mqPushConsumer;

    public RocketMQConsumer(RocketMQEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    private void startConsumer() throws MQClientException {
        if (this.mqPushConsumer != null) {
            this.logger.warn("Overriding RocketMQ Consumer! {}", (Object)this.mqPushConsumer);
        }
        this.mqPushConsumer = new DefaultMQPushConsumer(null, this.endpoint.getConsumerGroup(), AclUtils.getAclRPCHook(this.getEndpoint().getAccessKey(), this.getEndpoint().getSecretKey()));
        this.mqPushConsumer.setNamesrvAddr(this.endpoint.getNamesrvAddr());
        this.mqPushConsumer.subscribe(this.endpoint.getTopicName(), "*");
        this.mqPushConsumer.registerMessageListener(new MessageListenerConcurrently(){

            public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
                MessageExt messageExt = msgs.get(0);
                Exchange exchange = RocketMQConsumer.this.endpoint.createRocketExchange(messageExt.getBody());
                RocketMQConsumer.this.getEndpoint().getMessageConverter().setExchangeHeadersByMessageExt(exchange, messageExt);
                try {
                    RocketMQConsumer.this.getProcessor().process(exchange);
                }
                catch (Exception e) {
                    RocketMQConsumer.this.logger.warn(e.getLocalizedMessage());
                    e.printStackTrace();
                    return ConsumeConcurrentlyStatus.RECONSUME_LATER;
                }
                return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
            }
        });
        this.mqPushConsumer.start();
    }

    private void stopConsumer() {
        if (this.mqPushConsumer != null) {
            this.mqPushConsumer.shutdown();
            this.mqPushConsumer = null;
        }
    }

    public RocketMQEndpoint getEndpoint() {
        return (RocketMQEndpoint)super.getEndpoint();
    }

    protected void doSuspend() {
        this.stopConsumer();
    }

    protected void doResume() throws Exception {
        this.startConsumer();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.startConsumer();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.stopConsumer();
    }
}

