/*
 * Decompiled with CFR 0.152.
 */
package icu.wwj.camel.component.rocketmq;

import icu.wwj.camel.component.rocketmq.RocketMQComponent;
import icu.wwj.camel.component.rocketmq.RocketMQConsumer;
import icu.wwj.camel.component.rocketmq.RocketMQMessageConverter;
import icu.wwj.camel.component.rocketmq.RocketMQProducer;
import org.apache.camel.AsyncEndpoint;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.DefaultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.25.0", scheme="rocketmq", syntax="rocketmq:topicName", title="RocketMQ", label="messaging")
public class RocketMQEndpoint
extends DefaultEndpoint
implements AsyncEndpoint {
    private final Logger logger = LoggerFactory.getLogger(RocketMQEndpoint.class);
    @UriPath
    @Metadata(required=true)
    private String topicName;
    @UriParam(label="producer")
    private String producerGroup;
    @UriParam(label="consumer")
    private String consumerGroup;
    private final RocketMQMessageConverter messageConverter = new RocketMQMessageConverter();
    @UriParam(label="consumer", defaultValue="*")
    private String subscribeTags = "*";
    @UriParam(label="producer", defaultValue="")
    private String sendTag = "";
    @UriParam(label="producer")
    private String replyToTopic;
    @UriParam(label="producer")
    private String replyToConsumerGroup;
    @UriParam(label="common", defaultValue="localhost:9876")
    private String namesrvAddr = "localhost:9876";
    @UriParam(label="advance", defaultValue="10000")
    private Long requestTimeout = 10000L;
    @UriParam(label="advance", defaultValue="1000")
    private Long requestTimeoutCheckerInterval = 1000L;
    @UriParam(label="producer", defaultValue="false")
    private Boolean waitForSendResult = false;
    @UriParam(label="accessKey")
    private String accessKey;
    @UriParam(label="secretKey")
    private String secretKey;

    public RocketMQEndpoint() {
    }

    public RocketMQEndpoint(String endpointUri, RocketMQComponent component) {
        super(endpointUri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        return new RocketMQProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        RocketMQConsumer consumer = new RocketMQConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public boolean isSingleton() {
        return true;
    }

    public Exchange createRocketExchange(byte[] body) {
        Exchange exchange = super.createExchange();
        DefaultMessage message = new DefaultMessage(exchange.getContext());
        message.setBody((Object)body);
        exchange.setIn((Message)message);
        return exchange;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    public String getSubscribeTags() {
        return this.subscribeTags;
    }

    public void setSubscribeTags(String subscribeTags) {
        this.subscribeTags = subscribeTags;
    }

    public String getSendTag() {
        return this.sendTag;
    }

    public void setSendTag(String sendTag) {
        this.sendTag = sendTag;
    }

    public String getNamesrvAddr() {
        return this.namesrvAddr;
    }

    public void setNamesrvAddr(String namesrvAddr) {
        this.namesrvAddr = namesrvAddr;
    }

    public String getProducerGroup() {
        return this.producerGroup;
    }

    public void setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public String getReplyToTopic() {
        return this.replyToTopic;
    }

    public void setReplyToTopic(String replyToTopic) {
        this.replyToTopic = replyToTopic;
    }

    public String getReplyToConsumerGroup() {
        return this.replyToConsumerGroup;
    }

    public void setReplyToConsumerGroup(String replyToConsumerGroup) {
        this.replyToConsumerGroup = replyToConsumerGroup;
    }

    public RocketMQMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public Long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public Long getRequestTimeoutCheckerInterval() {
        return this.requestTimeoutCheckerInterval;
    }

    public void setRequestTimeoutCheckerInterval(Long requestTimeoutCheckerInterval) {
        this.requestTimeoutCheckerInterval = requestTimeoutCheckerInterval;
    }

    public Boolean getWaitForSendResult() {
        return this.waitForSendResult;
    }

    public void setWaitForSendResult(Boolean waitForSendResult) {
        this.waitForSendResult = waitForSendResult;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }
}

