/*
 * Decompiled with CFR 0.152.
 */
package icu.wwj.camel.component.rocketmq;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.support.DefaultMessage;
import org.apache.rocketmq.common.message.MessageExt;

public class RocketMQMessageConverter {
    public void setExchangeHeadersByMessageExt(Exchange exchange, MessageExt messageExt) {
        exchange.getIn().setHeader("rocketmq.BROKER_NAME", (Object)messageExt.getBrokerName());
        exchange.getIn().setHeader("rocketmq.QUEUE_ID", (Object)messageExt.getQueueId());
        exchange.getIn().setHeader("rocketmq.STORE_SIZE", (Object)messageExt.getStoreSize());
        exchange.getIn().setHeader("rocketmq.QUEUE_OFFSET", (Object)messageExt.getQueueOffset());
        exchange.getIn().setHeader("rocketmq.SYS_FLAG", (Object)messageExt.getSysFlag());
        exchange.getIn().setHeader("rocketmq.BORN_TIMESTAMP", (Object)messageExt.getBornTimestamp());
        exchange.getIn().setHeader("rocketmq.BORN_HOST", (Object)messageExt.getBornHost());
        exchange.getIn().setHeader("rocketmq.STORE_TIMESTAMP", (Object)messageExt.getStoreTimestamp());
        exchange.getIn().setHeader("rocketmq.STORE_HOST", (Object)messageExt.getStoreHost());
        exchange.getIn().setHeader("rocketmq.MSG_ID", (Object)messageExt.getMsgId());
        exchange.getIn().setHeader("rocketmq.COMMIT_LOG_OFFSET", (Object)messageExt.getCommitLogOffset());
        exchange.getIn().setHeader("rocketmq.BODY_CRC", (Object)messageExt.getBodyCRC());
        exchange.getIn().setHeader("rocketmq.RECONSUME_TIMES", (Object)messageExt.getReconsumeTimes());
        exchange.getIn().setHeader("rocketmq.PREPARED_TRANSACTION_OFFSET", (Object)messageExt.getPreparedTransactionOffset());
    }

    public void populateRocketExchange(Exchange exchange, MessageExt messageExt, boolean out) {
        Message message = this.resolveMessageFrom(exchange, out);
        this.populateRoutingInfoHeaders(message, messageExt);
    }

    private void populateRoutingInfoHeaders(Message message, MessageExt messageExt) {
        if (messageExt != null) {
            message.setHeader("rocketmq.TOPIC", (Object)messageExt.getTopic());
            message.setHeader("rocketmq.TAG", (Object)messageExt.getTags());
            message.setHeader("rocketmq.KEY", (Object)messageExt.getKeys());
        }
    }

    private Message resolveMessageFrom(Exchange exchange, boolean out) {
        Message message;
        if (out) {
            message = exchange.getOut();
        } else {
            message = exchange.getIn();
            if (message == null) {
                message = new DefaultMessage(exchange.getContext());
                exchange.setIn(message);
            }
        }
        return message;
    }
}

