/*
 * Decompiled with CFR 0.152.
 */
package icu.wwj.camel.component.rocketmq.reply;

import icu.wwj.camel.component.rocketmq.reply.ReplyHandler;
import icu.wwj.camel.component.rocketmq.reply.ReplyHolder;
import icu.wwj.camel.component.rocketmq.reply.ReplyManager;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.rocketmq.common.message.MessageExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQReplyHandler
implements ReplyHandler {
    protected final Logger logger = LoggerFactory.getLogger(RocketMQReplyHandler.class);
    protected final ReplyManager replyManager;
    protected final Exchange exchange;
    protected final AsyncCallback callback;
    protected final String messageKey;
    protected final long timeout;

    public RocketMQReplyHandler(ReplyManager replyManager, Exchange exchange, AsyncCallback callback, String messageKey, long timeout) {
        this.replyManager = replyManager;
        this.exchange = exchange;
        this.callback = callback;
        this.messageKey = messageKey;
        this.timeout = timeout;
    }

    @Override
    public void onReply(String messageKey, MessageExt messageExt) {
        this.logger.debug("onReply with messageKey: {}", (Object)messageKey);
        ReplyHolder holder = new ReplyHolder(this.exchange, this.callback, messageKey, messageExt);
        this.replyManager.processReply(holder);
    }

    @Override
    public void onTimeout(String messageKey) {
        this.logger.debug("onTimeout with messageKey: {}", (Object)messageKey);
        ReplyHolder holder = new ReplyHolder(this.exchange, this.callback, messageKey, this.timeout);
        this.replyManager.processReply(holder);
    }
}

