/*
 * Decompiled with CFR 0.152.
 */
package icu.xuyijie.base64utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class Base64Util {
    public static String transferToBase64(String filePath) throws IOException {
        File file = new File(filePath);
        byte[] fileContent = Files.readAllBytes(file.toPath());
        return Base64.encodeBase64String((byte[])fileContent);
    }

    public static String transferToBase64(File file) throws IOException {
        byte[] fileContent = Files.readAllBytes(file.toPath());
        return Base64.encodeBase64String((byte[])fileContent);
    }

    private static Map<String, String> handler(String base64Str, String filePath) {
        String fileName;
        String base64 = StringUtils.substringAfter((String)base64Str, (String)";base64,");
        if (StringUtils.isEmpty((CharSequence)base64)) {
            base64 = base64Str;
        }
        if (StringUtils.isEmpty((CharSequence)(fileName = StringUtils.substringAfterLast((String)filePath, (String)"/")))) {
            fileName = StringUtils.substringAfterLast((String)filePath, (String)"\\");
        }
        if (!fileName.contains(".")) {
            String suffix = StringUtils.substringBetween((String)base64Str, (String)"/", (String)";");
            if (StringUtils.isEmpty((CharSequence)suffix)) {
                filePath = filePath + ".png";
                System.out.println("\u4f20\u5165\u7684base64Str\u6ca1\u6709\u524d\u7f00\uff0c\u5e76\u4e14\u4f20\u5165\u7684fileName\u6ca1\u6709\u6269\u5c55\u540d\uff0c\u6240\u4ee5\u65e0\u6cd5\u786e\u5b9a\u6587\u4ef6\u7c7b\u578b\uff0c\u9ed8\u8ba4\u4ee5png\u683c\u5f0f\u8f93\u51fa");
            } else {
                filePath = suffix.contains("wordprocessing") ? filePath + ".docx" : (suffix.contains("presentation") ? filePath + ".pptx" : (suffix.contains("spreadsheet") ? filePath + ".xlsx" : (suffix.contains("excel") ? filePath + ".xls" : (suffix.contains("word") ? filePath + ".doc" : (suffix.contains("powerpoint") ? filePath + ".ppt" : (suffix.contains("octet-stream") ? filePath + ".rar" : (suffix.contains("zip") ? filePath + ".zip" : ("plain".equals(suffix) ? filePath + ".txt" : filePath + "." + suffix))))))));
            }
        }
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("base64", base64);
        map.put("filePath", filePath);
        return map;
    }

    public static String generateFile(String base64Str, String folderPath, String fileName) {
        String filePath = folderPath.endsWith("\\") || folderPath.endsWith("/") ? folderPath + fileName : folderPath + "/" + fileName;
        Map<String, String> map = Base64Util.handler(base64Str, filePath);
        filePath = map.get("filePath");
        String base64 = map.get("base64");
        File dir = new File(folderPath);
        if (!dir.exists() && !dir.isDirectory()) {
            dir.mkdirs();
        }
        if (base64 == null) {
            return "\u6587\u4ef6\u4e3a\u7a7a";
        }
        try {
            byte[] bytes = Base64.decodeBase64((String)base64);
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] >= 0) continue;
                int n = i;
                bytes[n] = (byte)(bytes[n] + 256);
            }
            BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));
            out.write(bytes);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filePath;
    }

    public static String generateFile(String base64Str, String filePath) {
        Map<String, String> map = Base64Util.handler(base64Str, filePath);
        filePath = map.get("filePath");
        String base64 = map.get("base64");
        String folderPath = StringUtils.substringBeforeLast((String)filePath, (String)"/");
        File dir = new File(folderPath);
        if (!dir.exists() && !dir.isDirectory()) {
            dir.mkdirs();
        }
        if (base64 == null) {
            return "\u6587\u4ef6\u4e3a\u7a7a";
        }
        try {
            BufferedOutputStream out;
            byte[] bytes = Base64.decodeBase64((String)base64);
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] >= 0) continue;
                int n = i;
                bytes[n] = (byte)(bytes[n] + 256);
            }
            try {
                out = new BufferedOutputStream(Files.newOutputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));
            }
            catch (Exception e) {
                folderPath = StringUtils.substringBeforeLast((String)filePath, (String)"\\");
                dir = new File(folderPath);
                if (!dir.exists() && !dir.isDirectory()) {
                    dir.mkdirs();
                }
                out = new BufferedOutputStream(Files.newOutputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));
            }
            out.write(bytes);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filePath;
    }
}

