/*
 * Decompiled with CFR 0.152.
 */
package icu.xuyijie.base64utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base64Utils {
    private static final Logger logger = LoggerFactory.getLogger(Base64Utils.class);
    private static final String WINDOWS_FILE_SEPARATOR = "\\";
    private static final String LINUX_FILE_SEPARATOR = "/";
    private static final String BASE64_MAP_KEY = "base64";
    private static final String FILEPATH_MAP_KEY = "filePath";

    private Base64Utils() {
    }

    public static String transferToBase64(String filePath) throws IOException {
        File file = new File(filePath);
        byte[] fileContent = Files.readAllBytes(file.toPath());
        return Base64.encodeBase64String((byte[])fileContent);
    }

    public static String transferToBase64(File file) throws IOException {
        byte[] fileContent = Files.readAllBytes(file.toPath());
        return Base64.encodeBase64String((byte[])fileContent);
    }

    private static Map<String, String> handler(String base64Str, String filePath) {
        String fileName;
        if (StringUtils.isBlank((CharSequence)base64Str)) {
            return Collections.emptyMap();
        }
        String base64 = StringUtils.substringAfter((String)base64Str, (String)";base64,");
        if (StringUtils.isEmpty((CharSequence)base64)) {
            base64 = base64Str;
        }
        if (StringUtils.isEmpty((CharSequence)(fileName = StringUtils.substringAfterLast((String)filePath, (String)WINDOWS_FILE_SEPARATOR)))) {
            fileName = StringUtils.substringAfterLast((String)filePath, (String)LINUX_FILE_SEPARATOR);
        }
        if (!fileName.contains(".")) {
            String suffix = StringUtils.substringBetween((String)base64Str, (String)LINUX_FILE_SEPARATOR, (String)";");
            if (StringUtils.isEmpty((CharSequence)suffix)) {
                filePath = (String)filePath + ".png";
                logger.warn("\u4f20\u5165\u7684base64\u6ca1\u6709\u524d\u7f00\uff0c\u5e76\u4e14\u4f20\u5165\u7684\u6587\u4ef6\u540d\u6ca1\u6709\u6269\u5c55\u540d\uff0c\u6240\u4ee5\u65e0\u6cd5\u786e\u5b9a\u6587\u4ef6\u7c7b\u578b\uff0c\u9ed8\u8ba4\u4ee5png\u683c\u5f0f\u4fdd\u5b58");
            } else {
                filePath = suffix.contains("wordprocessing") ? (String)filePath + ".docx" : (suffix.contains("presentation") ? (String)filePath + ".pptx" : (suffix.contains("spreadsheet") ? (String)filePath + ".xlsx" : (suffix.contains("excel") ? (String)filePath + ".xls" : (suffix.contains("word") ? (String)filePath + ".doc" : (suffix.contains("powerpoint") ? (String)filePath + ".ppt" : (suffix.contains("octet-stream") ? (String)filePath + ".rar" : (suffix.contains("zip") ? (String)filePath + ".zip" : (suffix.contains("plain") ? (String)filePath + ".txt" : (String)filePath + "." + suffix))))))));
            }
        }
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put(BASE64_MAP_KEY, base64);
        map.put(FILEPATH_MAP_KEY, (String)filePath);
        return map;
    }

    private static void saveFile(String base64, String filePath) {
        try {
            byte[] bytes = Base64.decodeBase64((String)base64);
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] >= 0) continue;
                int n = i;
                bytes[n] = (byte)(bytes[n] + 256);
            }
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));){
                out.write(bytes);
                out.flush();
            }
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
            e.printStackTrace();
        }
    }

    public static String generateFile(String base64Str, String folderPath, String fileName) {
        Object filePath = folderPath.endsWith(WINDOWS_FILE_SEPARATOR) || folderPath.endsWith(LINUX_FILE_SEPARATOR) ? folderPath + fileName : folderPath + LINUX_FILE_SEPARATOR + fileName;
        Map<String, String> map = Base64Utils.handler(base64Str, (String)filePath);
        if (map.isEmpty()) {
            logger.error("base64\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
            return "";
        }
        filePath = map.get(FILEPATH_MAP_KEY);
        String base64 = map.get(BASE64_MAP_KEY);
        File dir = new File(folderPath);
        if (!dir.isDirectory() && !dir.mkdirs()) {
            logger.error("\u4fdd\u5b58\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25\uff1a{}", (Object)folderPath);
        }
        Base64Utils.saveFile(base64, (String)filePath);
        return filePath;
    }

    public static String generateFile(String base64Str, String filePath) {
        Map<String, String> map = Base64Utils.handler(base64Str, filePath);
        if (map.isEmpty()) {
            logger.error("base64\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
            return "";
        }
        filePath = map.get(FILEPATH_MAP_KEY);
        String base64 = map.get(BASE64_MAP_KEY);
        String folderPath = StringUtils.substringBeforeLast((String)filePath, (String)LINUX_FILE_SEPARATOR);
        File dir = new File(folderPath);
        if (!(dir.isDirectory() || dir.mkdirs() || (dir = new File(folderPath = StringUtils.substringBeforeLast((String)filePath, (String)WINDOWS_FILE_SEPARATOR))).isDirectory() || dir.mkdirs())) {
            logger.error("\u4fdd\u5b58\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25\uff1a{}", (Object)folderPath);
        }
        Base64Utils.saveFile(base64, filePath);
        return filePath;
    }
}

