/*
 * Decompiled with CFR 0.152.
 */
package icu.xuyijie.base64utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Base64Utils {
    private static final Logger logger = LoggerFactory.getLogger(Base64Utils.class);
    private static final String WINDOWS_FILE_SEPARATOR = "\\";
    private static final String LINUX_FILE_SEPARATOR = "/";
    private static final String BASE64_MAP_KEY = "base64";
    private static final String FILEPATH_MAP_KEY = "filePath";

    private Base64Utils() {
    }

    public static String transferToBase64(String filePath) {
        return Base64Utils.transferToBase64(new File(filePath));
    }

    public static String transferToBase64(File file) {
        byte[] fileContent = new byte[]{};
        try {
            fileContent = Files.readAllBytes(file.toPath());
        }
        catch (IOException e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
        }
        return Base64.encodeBase64String((byte[])fileContent);
    }

    private static Map<String, String> handler(String base64Str, String filePath) {
        String fileName;
        if (StringUtils.isBlank((CharSequence)base64Str)) {
            return Collections.emptyMap();
        }
        String base64 = StringUtils.substringAfter((String)base64Str, (String)";base64,");
        if (StringUtils.isEmpty((CharSequence)base64)) {
            base64 = base64Str;
        }
        if (StringUtils.isEmpty((CharSequence)(fileName = StringUtils.substringAfterLast((String)filePath, (String)WINDOWS_FILE_SEPARATOR)))) {
            fileName = StringUtils.substringAfterLast((String)filePath, (String)LINUX_FILE_SEPARATOR);
        }
        if (!fileName.contains(".")) {
            String fileType = Base64Utils.getFileType(base64Str);
            filePath = filePath + "." + fileType;
        }
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put(BASE64_MAP_KEY, base64);
        map.put(FILEPATH_MAP_KEY, filePath);
        return map;
    }

    public static String getFileType(String base64Str) {
        String fileType;
        String suffix = StringUtils.substringBetween((String)base64Str, (String)LINUX_FILE_SEPARATOR, (String)";base64,");
        if (StringUtils.isEmpty((CharSequence)suffix)) {
            fileType = "png";
            logger.warn("\u4f20\u5165\u7684base64\u6ca1\u6709\u524d\u7f00\uff0c\u5e76\u4e14\u4f20\u5165\u7684\u6587\u4ef6\u540d\u6ca1\u6709\u6269\u5c55\u540d\uff0c\u6240\u4ee5\u65e0\u6cd5\u786e\u5b9a\u6587\u4ef6\u7c7b\u578b\uff0c\u9ed8\u8ba4\u4ee5png\u683c\u5f0f\u4fdd\u5b58");
        } else {
            fileType = suffix.contains("wordprocessing") ? "docx" : (suffix.contains("presentation") ? "pptx" : (suffix.contains("spreadsheet") ? "xlsx" : (suffix.contains("excel") ? "xls" : (suffix.contains("msword") ? "doc" : (suffix.contains("powerpoint") ? "ppt" : (suffix.contains("octet-stream") ? "rar" : (suffix.contains("zip") ? "zip" : (suffix.contains("plain") ? "txt" : (suffix.contains("x-icon") ? "icon" : (suffix.contains("svg") ? "svg" : suffix))))))))));
        }
        return fileType;
    }

    public static File getFile(String base64) {
        try {
            byte[] bytes = Base64Utils.decodeBase64(base64);
            File tempFile = File.createTempFile(String.valueOf(System.currentTimeMillis()), ".tmp");
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(tempFile.toPath(), new OpenOption[0]));){
                out.write(bytes);
                out.flush();
            }
            tempFile.deleteOnExit();
            return tempFile;
        }
        catch (Exception e) {
            logger.error("base64\u8f6c\u6362\u6587\u4ef6\u5bf9\u8c61\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    public static FileInputStream getFileStream(String base64) {
        File tempFile = Base64Utils.getFile(base64);
        if (tempFile != null) {
            try {
                return new FileInputStream(tempFile);
            }
            catch (Exception e) {
                logger.error("base64\u8f6c\u6362\u6587\u4ef6\u6d41\u5931\u8d25", (Throwable)e);
            }
        }
        return null;
    }

    private static void saveFile(String base64, String filePath) {
        try {
            byte[] bytes = Base64Utils.decodeBase64(base64);
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));){
                out.write(bytes);
                out.flush();
            }
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
        }
    }

    private static byte[] decodeBase64(String base64) {
        byte[] bytes = Base64.decodeBase64((String)base64);
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] >= 0) continue;
            int n = i;
            bytes[n] = (byte)(bytes[n] + 0);
        }
        return bytes;
    }

    public static String generateFile(String base64Str, String folderPath, String fileName) {
        String filePath = folderPath.endsWith(WINDOWS_FILE_SEPARATOR) || folderPath.endsWith(LINUX_FILE_SEPARATOR) ? folderPath + fileName : folderPath + LINUX_FILE_SEPARATOR + fileName;
        Map<String, String> map = Base64Utils.handler(base64Str, filePath);
        if (map.isEmpty()) {
            logger.error("base64\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
            return "";
        }
        filePath = map.get(FILEPATH_MAP_KEY);
        String base64 = map.get(BASE64_MAP_KEY);
        File dir = new File(folderPath);
        if (!dir.isDirectory() && !dir.mkdirs()) {
            logger.error("\u4fdd\u5b58\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25\uff1a{}", (Object)folderPath);
        }
        Base64Utils.saveFile(base64, filePath);
        return filePath;
    }

    public static String generateFile(String base64Str, String filePath) {
        Map<String, String> map = Base64Utils.handler(base64Str, filePath);
        if (map.isEmpty()) {
            logger.error("base64\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
            return "";
        }
        filePath = map.get(FILEPATH_MAP_KEY);
        String base64 = map.get(BASE64_MAP_KEY);
        String folderPath = StringUtils.substringBeforeLast((String)filePath, (String)LINUX_FILE_SEPARATOR);
        File dir = new File(folderPath);
        if (!(dir.isDirectory() || dir.mkdirs() || (dir = new File(folderPath = StringUtils.substringBeforeLast((String)filePath, (String)WINDOWS_FILE_SEPARATOR))).isDirectory() || dir.mkdirs())) {
            logger.error("\u4fdd\u5b58\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25\uff1a{}", (Object)folderPath);
        }
        Base64Utils.saveFile(base64, filePath);
        return filePath;
    }
}

