/*
 * Decompiled with CFR 0.152.
 */
package icu.xuyijie.base64utils;

import java.util.Optional;
import java.util.stream.Stream;

public enum Base64FileTypeEnum {
    DOC(".doc", "data:application/msword;base64"),
    DOCX(".docx", "data:application/vnd.openxmlformats-officedocument.wordprocessingml.document;base64"),
    XLS(".xls", "data:application/vnd.ms-excel;base64"),
    XLSX(".xlsx", "data:application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;base64"),
    PDF(".pdf", "data:application/pdf;base64"),
    PPT(".ppt", "data:application/vnd.ms-powerpoint;base64"),
    PPTX(".pptx", "data:application/vnd.openxmlformats-officedocument.presentationml.presentation;base64"),
    TXT(".txt", "data:text/plain;base64"),
    ZIP(".zip", "data:application/x-zip-compressed;base64"),
    RAR(".rar", "data:application/x-compressed;base64"),
    MP3(".mp3", "data:audio/mpeg;base64"),
    JPG(".jpg", "data:image/jpeg;base64"),
    GIF(".gif", "data:image/gif;base64"),
    SVG(".svg", "data:image/svg+xml;base64"),
    ICO(".ico", "data:image/x-icon;base64"),
    BMP(".bmp", "data:image/bmp;base64"),
    OCTET_STREAM(".heic", "data:application/octet-stream;base64,");

    private final String type;
    private final String prefix;

    private Base64FileTypeEnum(String type, String prefix) {
        this.type = type;
        this.prefix = prefix;
    }

    public String getType() {
        return this.type;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static String getFileType(String prefix) {
        Optional<Base64FileTypeEnum> optional = Stream.of(Base64FileTypeEnum.values()).filter(item -> item.getPrefix().contains(prefix)).findFirst();
        if (optional.isPresent()) {
            return optional.get().getType();
        }
        return "." + prefix;
    }
}

