/*
 * Decompiled with CFR 0.152.
 */
package icu.xuyijie.base64utils;

import icu.xuyijie.base64utils.Base64FileTypeEnum;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class Base64Utils {
    private static final Logger logger = Logger.getLogger(Base64Utils.class.getPackage().getName());
    private static final String WINDOWS_FILE_SEPARATOR = "\\";
    private static final String LINUX_FILE_SEPARATOR = "/";
    protected static final String FILE_TYPE_SEPARATOR = ".";
    private static final String BASE64_MAP_KEY = "base64";
    private static final String FILEPATH_MAP_KEY = "filePath";
    private static final String BASE64_PREFIX_SUBSTRING = ";base64,";

    private Base64Utils() {
    }

    public static String transferToBase64(String filePath, boolean hasPrefix) {
        return Base64Utils.transferToBase64(new File(filePath), hasPrefix);
    }

    public static String transferToBase64(File file, boolean hasPrefix) {
        byte[] fileContent = new byte[]{};
        try {
            fileContent = Files.readAllBytes(file.toPath());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\u2014\u2014", e);
        }
        String base64 = Base64.getEncoder().encodeToString(fileContent);
        if (hasPrefix) {
            String fileName = file.getName();
            String fileType = fileName.substring(fileName.lastIndexOf(FILE_TYPE_SEPARATOR));
            base64 = Base64FileTypeEnum.getPrefix(fileType) + base64;
        }
        return base64;
    }

    private static Map<String, String> handler(String base64Str, String filePath) {
        String base64NoPrefix = Base64Utils.getNoPrefixBase64(base64Str);
        if (StringUtils.isEmpty((CharSequence)base64NoPrefix)) {
            return Collections.emptyMap();
        }
        String fileName = StringUtils.substringAfterLast((String)filePath, (String)WINDOWS_FILE_SEPARATOR);
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            fileName = StringUtils.substringAfterLast((String)filePath, (String)LINUX_FILE_SEPARATOR);
        }
        if (!fileName.contains(FILE_TYPE_SEPARATOR)) {
            String fileType = Base64Utils.getFileType(base64Str);
            filePath = filePath + fileType;
        }
        HashMap<String, String> map = new HashMap<String, String>(4, 1.0f);
        map.put(BASE64_MAP_KEY, base64NoPrefix);
        map.put(FILEPATH_MAP_KEY, filePath);
        return map;
    }

    public static String getNoPrefixBase64(String base64Str) {
        if (StringUtils.isBlank((CharSequence)base64Str)) {
            logger.log(Level.WARNING, "\u4f20\u5165\u7684base64\u4e3a\u7a7a");
            return "";
        }
        String base64NoPrefix = StringUtils.substringAfter((String)base64Str, (String)BASE64_PREFIX_SUBSTRING);
        if (StringUtils.isEmpty((CharSequence)base64NoPrefix)) {
            base64NoPrefix = base64Str;
        }
        return base64NoPrefix;
    }

    public static String getFileType(String base64Str) {
        String fileType;
        String base64Prefix = StringUtils.substringBetween((String)base64Str, (String)LINUX_FILE_SEPARATOR, (String)BASE64_PREFIX_SUBSTRING);
        if (StringUtils.isEmpty((CharSequence)base64Prefix)) {
            fileType = ".png";
            logger.log(Level.WARNING, "\u4f20\u5165\u7684base64\u6ca1\u6709\u524d\u7f00\uff0c\u5e76\u4e14\u4f20\u5165\u7684\u6587\u4ef6\u540d\u6ca1\u6709\u6269\u5c55\u540d\uff0c\u6240\u4ee5\u65e0\u6cd5\u786e\u5b9a\u6587\u4ef6\u7c7b\u578b\uff0c\u9ed8\u8ba4png\u683c\u5f0f");
        } else {
            fileType = Base64FileTypeEnum.getFileType(base64Prefix);
        }
        return fileType;
    }

    public static File getFile(String base64Str) {
        try {
            String fileType = Base64Utils.getFileType(base64Str);
            String base64NoPrefix = Base64Utils.getNoPrefixBase64(base64Str);
            byte[] bytes = Base64Utils.decodeBase64(base64NoPrefix);
            File tempFile = File.createTempFile(String.valueOf(System.currentTimeMillis()), fileType);
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(tempFile.toPath(), new OpenOption[0]));){
                out.write(bytes);
                out.flush();
            }
            tempFile.deleteOnExit();
            return tempFile;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "base64\u8f6c\u6362\u6587\u4ef6\u5bf9\u8c61\u5931\u8d25\u2014\u2014", e);
            return null;
        }
    }

    public static FileInputStream getFileStream(String base64Str) {
        File tempFile = Base64Utils.getFile(base64Str);
        if (tempFile != null) {
            try {
                return new FileInputStream(tempFile);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "base64\u8f6c\u6362\u6587\u4ef6\u6d41\u5931\u8d25\u2014\u2014", e);
            }
        }
        return null;
    }

    private static void saveFile(String base64NoPrefix, String filePath) {
        try {
            byte[] bytes = Base64Utils.decodeBase64(base64NoPrefix);
            try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));){
                out.write(bytes);
                out.flush();
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "\u6587\u4ef6\u4fdd\u5b58\u5931\u8d25\u2014\u2014", e);
        }
    }

    private static byte[] decodeBase64(String base64Str) {
        byte[] bytes = Base64.getDecoder().decode(base64Str);
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] >= 0) continue;
            int n = i;
            bytes[n] = (byte)(bytes[n] + 0);
        }
        return bytes;
    }

    public static String generateFile(String base64Str, String folderPath, String fileName) {
        String filePath = folderPath.endsWith(WINDOWS_FILE_SEPARATOR) || folderPath.endsWith(LINUX_FILE_SEPARATOR) ? folderPath + fileName : folderPath + LINUX_FILE_SEPARATOR + fileName;
        Map<String, String> map = Base64Utils.handler(base64Str, filePath);
        if (map.isEmpty()) {
            logger.log(Level.WARNING, "base64\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
            return "";
        }
        filePath = map.get(FILEPATH_MAP_KEY);
        String base64NoPrefix = map.get(BASE64_MAP_KEY);
        File dir = new File(folderPath);
        if (!dir.isDirectory() && !dir.mkdirs()) {
            logger.log(Level.WARNING, "\u4fdd\u5b58\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25\uff1a{}", folderPath);
        }
        Base64Utils.saveFile(base64NoPrefix, filePath);
        return filePath;
    }

    public static String generateFile(String base64Str, String filePath) {
        Map<String, String> map = Base64Utils.handler(base64Str, filePath);
        if (map.isEmpty()) {
            logger.log(Level.WARNING, "base64\u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
            return "";
        }
        filePath = map.get(FILEPATH_MAP_KEY);
        String base64NoPrefix = map.get(BASE64_MAP_KEY);
        String folderPath = StringUtils.substringBeforeLast((String)filePath, (String)LINUX_FILE_SEPARATOR);
        File dir = new File(folderPath);
        if (!(dir.isDirectory() || dir.mkdirs() || (dir = new File(folderPath = StringUtils.substringBeforeLast((String)filePath, (String)WINDOWS_FILE_SEPARATOR))).isDirectory() || dir.mkdirs())) {
            logger.log(Level.WARNING, "\u4fdd\u5b58\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25\uff1a{}", folderPath);
        }
        Base64Utils.saveFile(base64NoPrefix, filePath);
        return filePath;
    }
}

