/*
 * Decompiled with CFR 0.152.
 */
package icu.xuyijie.sm4utils.util;

import icu.xuyijie.sm4utils.util.SM4_Context;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SM4 {
    private static final Logger logger = LoggerFactory.getLogger(SM4.class);
    public static final int SM4_ENCRYPT = 1;
    public static final int SM4_DECRYPT = 0;
    public static final byte[] SBOX_TABLE = new byte[]{-42, -112, -23, -2, -52, -31, 61, -73, 22, -74, 20, -62, 40, -5, 44, 5, 43, 103, -102, 118, 42, -66, 4, -61, -86, 68, 19, 38, 73, -122, 6, -103, -100, 66, 80, -12, -111, -17, -104, 122, 51, 84, 11, 67, -19, -49, -84, 98, -28, -77, 28, -87, -55, 8, -24, -107, -128, -33, -108, -6, 117, -113, 63, -90, 71, 7, -89, -4, -13, 115, 23, -70, -125, 89, 60, 25, -26, -123, 79, -88, 104, 107, -127, -78, 113, 100, -38, -117, -8, -21, 15, 75, 112, 86, -99, 53, 30, 36, 14, 94, 99, 88, -47, -94, 37, 34, 124, 59, 1, 33, 120, -121, -44, 0, 70, 87, -97, -45, 39, 82, 76, 54, 2, -25, -96, -60, -56, -98, -22, -65, -118, -46, 64, -57, 56, -75, -93, -9, -14, -50, -7, 97, 21, -95, -32, -82, 93, -92, -101, 52, 26, 85, -83, -109, 50, 48, -11, -116, -79, -29, 29, -10, -30, 46, -126, 102, -54, 96, -64, 41, 35, -85, 13, 83, 78, 111, -43, -37, 55, 69, -34, -3, -114, 47, 3, -1, 106, 114, 109, 108, 91, 81, -115, 27, -81, -110, -69, -35, -68, 127, 17, -39, 92, 65, 31, 16, 90, -40, 10, -63, 49, -120, -91, -51, 123, -67, 45, 116, -48, 18, -72, -27, -76, -80, -119, 105, -105, 74, 12, -106, 119, 126, 101, -71, -15, 9, -59, 110, -58, -124, 24, -16, 125, -20, 58, -36, 77, 32, 121, -18, 95, 62, -41, -53, 57, 72};
    public static final int[] FK = new int[]{-1548633402, 1453994832, 1736282519, -1301273892};
    public static final int[] CK = new int[]{462357, 472066609, 943670861, 1415275113, 1886879365, -1936483679, -1464879427, -993275175, -521670923, -66909679, 404694573, 876298825, 1347903077, 1819507329, -2003855715, -1532251463, -1060647211, -589042959, -117504499, 337322537, 808926789, 1280531041, 1752135293, -2071227751, -1599623499, -1128019247, -656414995, -184876535, 269950501, 741554753, 1213159005, 1684763257};

    SM4() {
    }

    private int GET_ULONG_BE(byte[] b, int i) {
        return (b[i] & 0xFF) << 24 | (b[i + 1] & 0xFF) << 16 | (b[i + 2] & 0xFF) << 8 | b[i + 3] & 0xFF & 0xFFFFFFFF;
    }

    private void PUT_ULONG_BE(int n, byte[] b, int i) {
        b[i] = (byte)(0xFF & n >> 24);
        b[i + 1] = (byte)(0xFF & n >> 16);
        b[i + 2] = (byte)(0xFF & n >> 8);
        b[i + 3] = (byte)(0xFF & n);
    }

    private int SHL(int x, int n) {
        return (x & 0xFFFFFFFF) << n;
    }

    private int ROTL(int x, int n) {
        return this.SHL(x, n) | x >> 32 - n;
    }

    private byte sm4Sbox(byte inch) {
        int i = inch & 0xFF;
        byte retVal = SBOX_TABLE[i];
        return retVal;
    }

    private int sm4Lt(int ka) {
        byte[] a = new byte[4];
        byte[] b = new byte[4];
        this.PUT_ULONG_BE(ka, a, 0);
        b[0] = this.sm4Sbox(a[0]);
        b[1] = this.sm4Sbox(a[1]);
        b[2] = this.sm4Sbox(a[2]);
        b[3] = this.sm4Sbox(a[3]);
        int bb = this.GET_ULONG_BE(b, 0);
        int c = bb ^ this.ROTL(bb, 2) ^ this.ROTL(bb, 10) ^ this.ROTL(bb, 18) ^ this.ROTL(bb, 24);
        return c;
    }

    private int sm4F(int x0, int x1, int x2, int x3, int rk) {
        return x0 ^ this.sm4Lt(x1 ^ x2 ^ x3 ^ rk);
    }

    private int sm4CalciRK(int ka) {
        byte[] a = new byte[4];
        byte[] b = new byte[4];
        this.PUT_ULONG_BE(ka, a, 0);
        b[0] = this.sm4Sbox(a[0]);
        b[1] = this.sm4Sbox(a[1]);
        b[2] = this.sm4Sbox(a[2]);
        b[3] = this.sm4Sbox(a[3]);
        int bb = this.GET_ULONG_BE(b, 0);
        int rk = bb ^ this.ROTL(bb, 13) ^ this.ROTL(bb, 23);
        return rk;
    }

    private void sm4_setkey(int[] SK, byte[] key) {
        int[] mK = new int[4];
        int[] k = new int[36];
        mK[0] = this.GET_ULONG_BE(key, 0);
        mK[1] = this.GET_ULONG_BE(key, 4);
        mK[2] = this.GET_ULONG_BE(key, 8);
        mK[3] = this.GET_ULONG_BE(key, 12);
        k[0] = mK[0] ^ FK[0];
        k[1] = mK[1] ^ FK[1];
        k[2] = mK[2] ^ FK[2];
        k[3] = mK[3] ^ FK[3];
        for (int i = 0; i < 32; ++i) {
            k[i + 4] = k[i] ^ this.sm4CalciRK(k[i + 1] ^ k[i + 2] ^ k[i + 3] ^ CK[i]);
            SK[i] = k[i + 4];
        }
    }

    private void sm4_one_round(int[] sk, byte[] input, byte[] output) {
        int[] ulbuf = new int[36];
        ulbuf[0] = this.GET_ULONG_BE(input, 0);
        ulbuf[1] = this.GET_ULONG_BE(input, 4);
        ulbuf[2] = this.GET_ULONG_BE(input, 8);
        ulbuf[3] = this.GET_ULONG_BE(input, 12);
        for (int i = 0; i < 32; ++i) {
            ulbuf[i + 4] = this.sm4F(ulbuf[i], ulbuf[i + 1], ulbuf[i + 2], ulbuf[i + 3], sk[i]);
        }
        this.PUT_ULONG_BE(ulbuf[35], output, 0);
        this.PUT_ULONG_BE(ulbuf[34], output, 4);
        this.PUT_ULONG_BE(ulbuf[33], output, 8);
        this.PUT_ULONG_BE(ulbuf[32], output, 12);
    }

    private byte[] padding(byte[] input, int mode) {
        byte[] ret;
        if (mode == 1) {
            int p = 16 - input.length % 16;
            ret = new byte[input.length + p];
            System.arraycopy(input, 0, ret, 0, input.length);
            for (int i = 0; i < p; ++i) {
                ret[input.length + i] = (byte)p;
            }
        } else {
            byte p = input[input.length - 1];
            ret = new byte[input.length - p];
            System.arraycopy(input, 0, ret, 0, input.length - p);
        }
        return ret;
    }

    private void validateDecrypt(SM4_Context ctx, byte[] key) throws Exception {
        if (ctx == null) {
            logger.error("ctx is null");
            throw new Exception("ctx is null!");
        }
        if (key == null || key.length != 16) {
            logger.error("secretKey\u5fc5\u987b\u4e3a 16 \u4f4d\uff0c\u53ef\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u6807\u70b9");
            throw new Exception("secretKey\u5fc5\u987b\u4e3a 16 \u4f4d\uff0c\u53ef\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u6807\u70b9");
        }
    }

    private void validateEncrypt(String type, byte[] iv, byte[] input) throws Exception {
        if ("CBC".equals(type) && (iv == null || iv.length != 16)) {
            logger.error("iv\u5fc5\u987b\u4e3a 16 \u4f4d\uff0c\u53ef\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u6807\u70b9");
            throw new Exception("iv\u5fc5\u987b\u4e3a 16 \u4f4d\uff0c\u53ef\u5305\u542b\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u6807\u70b9");
        }
        if (input == null) {
            logger.error("\u8981\u52a0\u89e3\u5bc6\u7684\u6570\u636e\u4e3anull");
            throw new Exception("\u8981\u52a0\u89e3\u5bc6\u7684\u6570\u636e\u4e3anull");
        }
    }

    public void sm4_setkey_enc(SM4_Context ctx, byte[] key) throws Exception {
        this.validateDecrypt(ctx, key);
        ctx.mode = 1;
        this.sm4_setkey(ctx.sk, key);
    }

    public byte[] sm4_crypt_ecb(SM4_Context ctx, byte[] input) throws Exception {
        this.validateEncrypt("ECB", null, input);
        if (ctx.isPadding && ctx.mode == 1) {
            input = this.padding(input, 1);
        }
        ByteArrayInputStream bins = new ByteArrayInputStream(input);
        ByteArrayOutputStream bous = new ByteArrayOutputStream();
        for (int length = input.length; length > 0; length -= 16) {
            byte[] in = new byte[16];
            byte[] out = new byte[16];
            bins.read(in);
            this.sm4_one_round(ctx.sk, in, out);
            bous.write(out);
        }
        byte[] output = bous.toByteArray();
        if (ctx.isPadding && ctx.mode == 0) {
            output = this.padding(output, 0);
        }
        bins.close();
        bous.close();
        return output;
    }

    public void sm4_setkey_dec(SM4_Context ctx, byte[] key) throws Exception {
        this.validateDecrypt(ctx, key);
        ctx.mode = 0;
        this.sm4_setkey(ctx.sk, key);
        for (int i = 0; i < 16; ++i) {
            this.SWAP(ctx.sk, i);
        }
    }

    private void SWAP(int[] sk, int i) {
        int t = sk[i];
        sk[i] = sk[31 - i];
        sk[31 - i] = t;
    }

    public byte[] sm4_crypt_cbc(SM4_Context ctx, byte[] iv, byte[] input) throws Exception {
        this.validateEncrypt("CBC", iv, input);
        if (ctx.isPadding && ctx.mode == 1) {
            input = this.padding(input, 1);
        }
        ByteArrayInputStream bins = new ByteArrayInputStream(input);
        ByteArrayOutputStream bous = new ByteArrayOutputStream();
        if (ctx.mode == 1) {
            for (length = input.length; length > 0; length -= 16) {
                byte[] in = new byte[16];
                byte[] out = new byte[16];
                byte[] out1 = new byte[16];
                bins.read(in);
                for (int i = 0; i < 16; ++i) {
                    out[i] = (byte)(in[i] ^ iv[i]);
                }
                this.sm4_one_round(ctx.sk, out, out1);
                System.arraycopy(out1, 0, iv, 0, 16);
                bous.write(out1);
            }
        } else {
            byte[] temp = new byte[16];
            while (length > 0) {
                byte[] in = new byte[16];
                byte[] out = new byte[16];
                byte[] out1 = new byte[16];
                bins.read(in);
                System.arraycopy(in, 0, temp, 0, 16);
                this.sm4_one_round(ctx.sk, in, out);
                for (int i = 0; i < 16; ++i) {
                    out1[i] = (byte)(out[i] ^ iv[i]);
                }
                System.arraycopy(temp, 0, iv, 0, 16);
                bous.write(out1);
                length -= 16;
            }
        }
        byte[] output = bous.toByteArray();
        if (ctx.isPadding && ctx.mode == 0) {
            output = this.padding(output, 0);
        }
        bins.close();
        bous.close();
        return output;
    }
}

