/*
 * Decompiled with CFR 0.152.
 */
package icu.xuyijie.sm4utils.util;

import icu.xuyijie.sm4utils.util.SM4;
import icu.xuyijie.sm4utils.util.SM4_Context;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM4Utils {
    private static final Logger logger = LoggerFactory.getLogger(SM4Utils.class);
    private static final String SECRET_KEY = "GJwsXX_BzW=gJWJW";
    private static final String IV = "ZkR_SiNoSOFT=568";
    static final String ECB = "ECB";
    static final String CBC = "CBC";
    private static final boolean HEX_STRING = false;
    private static final Pattern P = Pattern.compile("\\s*|\t|\r|\n");

    private SM4Utils() {
    }

    private static String encryptData(String type, String plainText, String secretKey, String iv) {
        try {
            String cipherText;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = secretKey == null ? SECRET_KEY.getBytes() : secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4SetKeyEnc(ctx, keyBytes);
            if (ECB.equals(type)) {
                byte[] encrypted = sm4.sm4CryptEcb(ctx, plainText.getBytes(StandardCharsets.UTF_8));
                cipherText = Base64.encodeBase64String((byte[])encrypted);
                if (cipherText != null && cipherText.trim().length() > 0) {
                    Matcher m = P.matcher(cipherText);
                    cipherText = m.replaceAll("");
                }
            } else {
                byte[] ivBytes = iv == null ? IV.getBytes() : iv.getBytes();
                byte[] encrypted = sm4.sm4CryptCbc(ctx, ivBytes, plainText.getBytes(StandardCharsets.UTF_8));
                cipherText = Base64.encodeBase64String((byte[])encrypted);
                if (cipherText != null && cipherText.trim().length() > 0) {
                    Matcher m = P.matcher(cipherText);
                    cipherText = m.replaceAll("");
                }
            }
            return cipherText;
        }
        catch (Exception e) {
            logger.error("\u52a0\u5bc6\u5931\u8d25\uff01", (Throwable)e);
            return null;
        }
    }

    private static String decryptData(String type, String cipherText, String secretKey, String iv) {
        try {
            byte[] bytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            SM4 sm4 = new SM4();
            byte[] byArray = bytes = secretKey == null ? SECRET_KEY.getBytes() : secretKey.getBytes();
            if (ECB.equals(type)) {
                sm4.sm4SetKeyDec(ctx, bytes);
                byte[] decrypted = sm4.sm4CryptEcb(ctx, Base64.decodeBase64((String)cipherText));
                return new String(decrypted, StandardCharsets.UTF_8);
            }
            byte[] keyBytes = bytes;
            byte[] ivBytes = iv == null ? IV.getBytes() : iv.getBytes();
            sm4.sm4SetKeyDec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4CryptCbc(ctx, ivBytes, Base64.decodeBase64((String)cipherText));
            return new String(decrypted, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            logger.error("\u89e3\u5bc6\u5931\u8d25\uff01\u8bf7\u68c0\u67e5\u5bc6\u94a5\u548c\u5bc6\u6587\u662f\u5426\u5bf9\u5e94", (Throwable)e);
            return null;
        }
    }

    public static String encryptData_ECB(String plainText, String secretKey) {
        return SM4Utils.encryptData(ECB, plainText, secretKey, null);
    }

    public static String encryptData_ECB(String plainText) {
        return SM4Utils.encryptData(ECB, plainText, null, null);
    }

    public static String decryptData_ECB(String cipherText, String secretKey) {
        return SM4Utils.decryptData(ECB, cipherText, secretKey, null);
    }

    public static String decryptData_ECB(String cipherText) {
        return SM4Utils.decryptData(ECB, cipherText, null, null);
    }

    public static String encryptData_CBC(String plainText, String secretKey, String iv) {
        return SM4Utils.encryptData(CBC, plainText, secretKey, iv);
    }

    public static String encryptData_CBC(String plainText) {
        return SM4Utils.encryptData(CBC, plainText, null, null);
    }

    public static String decryptData_CBC(String cipherText, String secretKey, String iv) {
        return SM4Utils.decryptData(CBC, cipherText, secretKey, iv);
    }

    public static String decryptData_CBC(String cipherText) {
        return SM4Utils.decryptData(CBC, cipherText, null, null);
    }
}

