/*
 * Decompiled with CFR 0.152.
 */
package icu.xuyijie.sm4utils.util;

import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Util {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private Util() {
    }

    public static byte[] intToBytes(int num) {
        byte[] bytes = new byte[]{(byte)(0xFF & num), (byte)(0xFF & num >> 8), (byte)(0xFF & num >> 16), (byte)(0xFF & num >> 24)};
        return bytes;
    }

    public static int byteToInt(byte[] bytes) {
        int num = 0;
        int temp = 0xFF & bytes[0];
        num |= temp;
        temp = (0xFF & bytes[1]) << 8;
        num |= temp;
        temp = (0xFF & bytes[2]) << 16;
        num |= temp;
        temp = (0xFF & bytes[3]) << 24;
        return num |= temp;
    }

    public static byte[] longToBytes(long num) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(0xFFL & num >> i * 8);
        }
        return bytes;
    }

    public static byte[] byteConvert32Bytes(BigInteger n) {
        byte[] tmp;
        if (n == null) {
            return null;
        }
        if (n.toByteArray().length == 33) {
            tmp = new byte[32];
            System.arraycopy(n.toByteArray(), 1, tmp, 0, 32);
        } else if (n.toByteArray().length == 32) {
            tmp = n.toByteArray();
        } else {
            tmp = new byte[32];
            for (int i = 0; i < 32 - n.toByteArray().length; ++i) {
                tmp[i] = 0;
            }
            System.arraycopy(n.toByteArray(), 0, tmp, 32 - n.toByteArray().length, n.toByteArray().length);
        }
        return tmp;
    }

    public static BigInteger byteConvertInteger(byte[] b) {
        if (b[0] < 0) {
            byte[] temp = new byte[b.length + 1];
            temp[0] = 0;
            System.arraycopy(b, 0, temp, 1, b.length);
            return new BigInteger(temp);
        }
        return new BigInteger(b);
    }

    public static String getHexString(byte[] bytes) {
        return Util.getHexString(bytes, true);
    }

    public static String getHexString(byte[] bytes, boolean upperCase) {
        StringBuilder ret = new StringBuilder();
        for (byte aByte : bytes) {
            ret.append(Integer.toString((aByte & 0xFF) + 256, 16).substring(1));
        }
        return upperCase ? ret.toString().toUpperCase() : ret.toString();
    }

    public static void printHexString(byte[] bytes) {
        for (byte aByte : bytes) {
            String hex = Integer.toHexString(aByte & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            System.out.println("0x" + hex.toUpperCase() + ",");
        }
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.isEmpty()) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(Util.charToByte(hexChars[pos]) << 4 | Util.charToByte(hexChars[pos + 1]) & 0xFF);
        }
        return d;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static char[] encodeHex(byte[] data) {
        return Util.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return Util.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (byte datum : data) {
            out[j++] = toDigits[(0xF0 & datum) >>> 4];
            out[j++] = toDigits[0xF & datum];
        }
        return out;
    }

    public static String encodeHexString(byte[] data) {
        return Util.encodeHexString(data, true);
    }

    public static String encodeHexString(byte[] data, boolean toLowerCase) {
        return Util.encodeHexString(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static String encodeHexString(byte[] data, char[] toDigits) {
        return new String(Util.encodeHex(data, toDigits));
    }

    public static byte[] decodeHex(char[] data) {
        int len = data.length;
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("\u5341\u516d\u8fdb\u5236char[]\u4e0d\u5408\u6cd5");
        }
        byte[] out = new byte[len >> 1];
        int j = 0;
        int i = 0;
        while (j < len) {
            int f = Util.toDigit(data[j], j) << 4;
            f |= Util.toDigit(data[++j], j);
            ++j;
            out[i] = (byte)(f & 0xFF);
            ++i;
        }
        return out;
    }

    protected static int toDigit(char ch, int index) {
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }

    public static String stringToAsciiString(String content) {
        StringBuilder result = new StringBuilder();
        int max = content.length();
        for (int i = 0; i < max; ++i) {
            char c = content.charAt(i);
            String b = Integer.toHexString(c);
            result.append(b);
        }
        return result.toString();
    }

    public static String hexStringToString(String hexString, int encodeType) {
        StringBuilder result = new StringBuilder();
        int max = hexString.length() / encodeType;
        for (int i = 0; i < max; ++i) {
            char c = (char)Util.hexStringToAlgorism(hexString.substring(i * encodeType, (i + 1) * encodeType));
            result.append(c);
        }
        return result.toString();
    }

    public static int hexStringToAlgorism(String hex) {
        hex = hex.toUpperCase();
        int max = hex.length();
        int result = 0;
        for (int i = max; i > 0; --i) {
            char c = hex.charAt(i - 1);
            int algorithm = c >= '0' && c <= '9' ? c - 48 : c - 55;
            result += (int)(Math.pow(16.0, max - i) * (double)algorithm);
        }
        return result;
    }

    public static String hexStringToBinary(String hex) {
        hex = hex.toUpperCase();
        StringBuilder result = new StringBuilder();
        int max = hex.length();
        block18: for (int i = 0; i < max; ++i) {
            char c = hex.charAt(i);
            switch (c) {
                case '0': {
                    result.append("0000");
                    continue block18;
                }
                case '1': {
                    result.append("0001");
                    continue block18;
                }
                case '2': {
                    result.append("0010");
                    continue block18;
                }
                case '3': {
                    result.append("0011");
                    continue block18;
                }
                case '4': {
                    result.append("0100");
                    continue block18;
                }
                case '5': {
                    result.append("0101");
                    continue block18;
                }
                case '6': {
                    result.append("0110");
                    continue block18;
                }
                case '7': {
                    result.append("0111");
                    continue block18;
                }
                case '8': {
                    result.append("1000");
                    continue block18;
                }
                case '9': {
                    result.append("1001");
                    continue block18;
                }
                case 'A': {
                    result.append("1010");
                    continue block18;
                }
                case 'B': {
                    result.append("1011");
                    continue block18;
                }
                case 'C': {
                    result.append("1100");
                    continue block18;
                }
                case 'D': {
                    result.append("1101");
                    continue block18;
                }
                case 'E': {
                    result.append("1110");
                    continue block18;
                }
                case 'F': {
                    result.append("1111");
                    continue block18;
                }
                default: {
                    logger.error("hexStringToBinary\u65e0\u5339\u914d\u9879");
                }
            }
        }
        return result.toString();
    }

    public static String asciiStringToString(String content) {
        StringBuilder result = new StringBuilder();
        int length = content.length() / 2;
        for (int i = 0; i < length; ++i) {
            String c = content.substring(i * 2, i * 2 + 2);
            int a = Util.hexStringToAlgorism(c);
            char b = (char)a;
            String d = String.valueOf(b);
            result.append(d);
        }
        return result.toString();
    }

    public static String algorismToHexString(int algorism, int maxLength) {
        String result = Integer.toHexString(algorism);
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        return Util.patchHexString(result.toUpperCase(), maxLength);
    }

    public static String byteToString(byte[] bytearray) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytearray) {
            char temp = (char)b;
            result.append(temp);
        }
        return result.toString();
    }

    public static int binaryToAlgorism(String binary) {
        int max = binary.length();
        int result = 0;
        for (int i = max; i > 0; --i) {
            char c = binary.charAt(i - 1);
            int algorism = c - 48;
            result += (int)(Math.pow(2.0, max - i) * (double)algorism);
        }
        return result;
    }

    public static String algorismToHexString(int algorism) {
        String result = Integer.toHexString(algorism);
        if (result.length() % 2 == 1) {
            result = "0" + result;
        }
        result = result.toUpperCase();
        return result;
    }

    public static String patchHexString(String str, int maxLength) {
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < maxLength - str.length(); ++i) {
            temp.insert(0, "0");
        }
        str = (temp + str).substring(0, maxLength);
        return str;
    }

    public static int parseToInt(String s, int defaultInt, int radix) {
        int i;
        try {
            i = Integer.parseInt(s, radix);
        }
        catch (NumberFormatException ex) {
            i = defaultInt;
        }
        return i;
    }

    public static int parseToInt(String s, int defaultInt) {
        int i;
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            i = defaultInt;
        }
        return i;
    }

    public static byte[] hexToByte(String hex) throws IllegalArgumentException {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        char[] arr = hex.toCharArray();
        byte[] b = new byte[hex.length() / 2];
        int i = 0;
        int j = 0;
        int l = hex.length();
        while (i < l) {
            String swap = String.valueOf(arr[i++]) + arr[i];
            int byteInt = Integer.parseInt(swap, 16) & 0xFF;
            b[j] = (byte)byteInt;
            ++i;
            ++j;
        }
        return b;
    }

    public static String byteToHex(byte[] b) {
        if (b == null) {
            throw new IllegalArgumentException("Argument b ( byte array ) is null! ");
        }
        StringBuilder hs = new StringBuilder();
        for (byte value : b) {
            String stmp = Integer.toHexString(value & 0xFF);
            if (stmp.length() == 1) {
                hs.append("0").append(stmp);
                continue;
            }
            hs.append(stmp);
        }
        return hs.toString().toUpperCase();
    }

    public static byte[] subByte(byte[] input, int startIndex, int length) {
        byte[] bt = new byte[length];
        System.arraycopy(input, startIndex, bt, 0, length);
        return bt;
    }
}

