/*
 * Decompiled with CFR 0.152.
 */
package in.adavi.pradyot.hash;

import in.adavi.pradyot.hash.SHA2AlgName;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtil {
    private static HashUtil hashUtil = new HashUtil();

    public static HashUtil getInstance() {
        return hashUtil;
    }

    public String generateSHA2(String data, SHA2AlgName sha2AlgName) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(sha2AlgName.getAlgName());
        byte[] messageDigest = md.digest(data.getBytes());
        BigInteger number = new BigInteger(1, messageDigest);
        String sha2Hash = number.toString(16);
        return sha2Hash;
    }

    public boolean verifyHash(String data, String sha2Hash, SHA2AlgName sha2AlgName) throws NoSuchAlgorithmException {
        String sha2HashToBeVerified = this.generateSHA2(data, sha2AlgName);
        return sha2HashToBeVerified.equals(sha2Hash);
    }
}

