/*
 * Decompiled with CFR 0.152.
 */
package in.adavi.pradyot.idgenerator;

import in.adavi.pradyot.idgenerator.UniqueIdGroup;
import java.util.Random;

public class UniqueIdGenerator {
    private final Random random = new Random();
    private UniqueIdGroup uniqueIdGroup = UniqueIdGroup.DATETIME;
    private String allowedChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ123456789";

    public void setUniqueIdGroup(UniqueIdGroup uniqueIdGroup) {
        this.uniqueIdGroup = uniqueIdGroup;
    }

    public void setAllowedChars(String allowedChars) {
        this.allowedChars = allowedChars;
    }

    private void appendRandomString(StringBuilder builder, int length) throws IllegalStateException {
        if (this.allowedChars.length() == 0) {
            throw new IllegalStateException("AllowedChars cannot be empty string");
        }
        while (builder.length() < length) {
            int randomPosition = this.random.nextInt(this.allowedChars.length());
            builder.append(this.allowedChars.charAt(randomPosition));
        }
    }

    public String generate(int length) throws IllegalArgumentException, IllegalStateException {
        return this.generate("", length);
    }

    public String generate(String prefix, int length) throws IllegalArgumentException, IllegalStateException {
        String base = this.uniqueIdGroup.getValue();
        StringBuilder builder = new StringBuilder(prefix);
        builder.append(base);
        if (length < builder.length() + 1) {
            throw new IllegalArgumentException("Cannot generate random string of length " + length + " for GeneratorType: " + this.uniqueIdGroup.getValue());
        }
        this.appendRandomString(builder, length);
        return builder.substring(0, length).toUpperCase();
    }
}

