/*
 * Decompiled with CFR 0.152.
 */
package in.ankushs.jvalet.utils;

import in.ankushs.jvalet.utils.PreConditions;

public class Enums {
    public static <T extends Enum<T>> T getEnumFromString(Class<T> enumClass, String value) {
        PreConditions.checkNull(enumClass, "enumClass cannot be null");
        PreConditions.checkNull(value, "value cannot be null");
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            if (!enumValue.toString().equalsIgnoreCase(value)) continue;
            return (T)enumValue;
        }
        StringBuilder errorMessage = new StringBuilder();
        boolean bFirstTime = true;
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            errorMessage.append(bFirstTime ? "" : ", ").append(enumValue);
            bFirstTime = false;
        }
        throw new IllegalArgumentException(value + " is invalid value. Supported values are " + errorMessage);
    }
}

