/*
 * Decompiled with CFR 0.152.
 */
package in.ashwanthkumar.suuchi.store.rocksdb;

import in.ashwanthkumar.suuchi.store.KV;
import in.ashwanthkumar.suuchi.store.Store;
import in.ashwanthkumar.suuchi.store.rocksdb.RocksDbConfiguration;
import in.ashwanthkumar.suuchi.utils.ByteArrayUtils$;
import in.ashwanthkumar.suuchi.utils.Logging;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u001b\ta!k\\2lg\u0012\u00137\u000b^8sK*\u00111\u0001B\u0001\be>\u001c7n\u001d3c\u0015\t)a!A\u0003ti>\u0014XM\u0003\u0002\b\u0011\u000511/^;dQ&T!!\u0003\u0006\u0002\u001b\u0005\u001c\bn^1oi\"\\W/\\1s\u0015\u0005Y\u0011AA5o\u0007\u0001\u0019B\u0001\u0001\b\u00151A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\f\u000e\u0003\u0011I!a\u0006\u0003\u0003\u000bM#xN]3\u0011\u0005eaR\"\u0001\u000e\u000b\u0005m1\u0011!B;uS2\u001c\u0018BA\u000f\u001b\u0005\u001daunZ4j]\u001eD\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0007G>tg-[4\u0011\u0005\u0005\u0012S\"\u0001\u0002\n\u0005\r\u0012!\u0001\u0006*pG.\u001cHIY\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003&\u0001\u0011\u0005a%\u0001\u0004=S:LGO\u0010\u000b\u0003O!\u0002\"!\t\u0001\t\u000b}!\u0003\u0019\u0001\u0011\t\u0011)\u0002\u0001R1A\u0005\u0002-\n!\u0001\u001a2\u0016\u00031\u0002\"!L\u0019\u000e\u00039R!aA\u0018\u000b\u0003A\n1a\u001c:h\u0013\t\u0011dFA\u0004S_\u000e\\7\u000f\u0012\"\t\u0011Q\u0002\u0001\u0012!Q!\n1\n1\u0001\u001a2!\u0011!1\u0004\u0001#b\u0001\n\u00039\u0014\u0001D<sSR,w\n\u001d;j_:\u001cX#\u0001\u001d\u0011\u00055J\u0014B\u0001\u001e/\u000519&/\u001b;f\u001fB$\u0018n\u001c8t\u0011!a\u0004\u0001#A!B\u0013A\u0014!D<sSR,w\n\u001d;j_:\u001c\b\u0005C\u0003?\u0001\u0011\u0005s(A\u0002hKR$\"\u0001Q%\u0011\u0007=\t5)\u0003\u0002C!\t1q\n\u001d;j_:\u00042a\u0004#G\u0013\t)\u0005CA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0010\u000f&\u0011\u0001\n\u0005\u0002\u0005\u0005f$X\rC\u0003K{\u0001\u00071)A\u0002lKfDQ\u0001\u0014\u0001\u0005B5\u000b1\u0001];u)\rq\u0015K\u0015\t\u0003\u001f=K!\u0001\u0015\t\u0003\u000f\t{w\u000e\\3b]\")!j\u0013a\u0001\u0007\")1k\u0013a\u0001\u0007\u0006)a/\u00197vK\")Q\u000b\u0001C\u0001-\u0006)1\r\\8tKR\tq\u000b\u0005\u0002\u00101&\u0011\u0011\f\u0005\u0002\u0005+:LG\u000fC\u0003\\\u0001\u0011\u0005C,\u0001\u0004sK6|g/\u001a\u000b\u0003\u001dvCQA\u0013.A\u0002\rCQa\u0018\u0001\u0005\u0002\u0001\fAa]2b]R\t\u0011\rE\u0002cU6t!a\u00195\u000f\u0005\u0011<W\"A3\u000b\u0005\u0019d\u0011A\u0002\u001fs_>$h(C\u0001\u0012\u0013\tI\u0007#A\u0004qC\u000e\\\u0017mZ3\n\u0005-d'\u0001C%uKJ\fGo\u001c:\u000b\u0005%\u0004\u0002CA\u000bo\u0013\tyGA\u0001\u0002L-\")q\f\u0001C\u0001cR\u0011\u0011M\u001d\u0005\u0006gB\u0004\raQ\u0001\u0007aJ,g-\u001b=")
public class RocksDbStore
implements Store,
Logging {
    private final RocksDbConfiguration config;
    private RocksDB db;
    private WriteOptions writeOptions;
    private final Logger log;
    private volatile byte bitmap$0;

    private RocksDB db$lzycompute() {
        RocksDbStore rocksDbStore = this;
        synchronized (rocksDbStore) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.db = this.config.readOnly() ? RocksDB.openReadOnly((Options)this.config.toOptions(), (String)this.config.location()) : RocksDB.open((Options)this.config.toOptions(), (String)this.config.location());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.db;
        }
    }

    private WriteOptions writeOptions$lzycompute() {
        RocksDbStore rocksDbStore = this;
        synchronized (rocksDbStore) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.writeOptions = new WriteOptions().setDisableWAL(false).setSync(true);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.writeOptions;
        }
    }

    public Logger log() {
        return this.log;
    }

    public void in$ashwanthkumar$suuchi$utils$Logging$_setter_$log_$eq(Logger x$1) {
        this.log = x$1;
    }

    public <T> Try<T> logOnError(Function0<T> f) {
        return Logging.class.logOnError((Logging)this, f);
    }

    public RocksDB db() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.db$lzycompute() : this.db;
    }

    public WriteOptions writeOptions() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.writeOptions$lzycompute() : this.writeOptions;
    }

    public synchronized Option<byte[]> get(byte[] key) {
        return Option$.MODULE$.apply((Object)this.db().get(key));
    }

    public synchronized boolean put(byte[] key, byte[] value) {
        return this.logOnError((Function0)new Serializable(this, key, value){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RocksDbStore $outer;
            private final byte[] key$1;
            private final byte[] value$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.db().put(this.$outer.writeOptions(), this.key$1, this.value$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$1 = key$1;
                this.value$1 = value$1;
            }
        }).isSuccess();
    }

    public void close() {
        this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Closing RocksDb]"})).s((Seq)Nil$.MODULE$));
        this.db().close();
    }

    public boolean remove(byte[] key) {
        return this.logOnError((Function0)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RocksDbStore $outer;
            private final byte[] key$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.db().remove(this.key$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.key$2 = key$2;
            }
        }).isSuccess();
    }

    public Iterator<KV> scan() {
        return this.scan((byte[])Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.Byte()));
    }

    public Iterator<KV> scan(byte[] prefix) {
        RocksIterator rocksIterator = this.db().newIterator();
        rocksIterator.seek(prefix);
        return new Iterator<KV>(this, prefix, rocksIterator){
            private final byte[] prefix$1;
            private final RocksIterator rocksIterator$1;

            public Iterator<KV> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<KV> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<KV> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<KV> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<KV, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<KV, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<KV> filter(Function1<KV, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<KV, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<KV> withFilter(Function1<KV, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<KV> filterNot(Function1<KV, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<KV, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, KV, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<KV, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<KV> takeWhile(Function1<KV, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<KV>, Iterator<KV>> partition(Function1<KV, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<KV>, Iterator<KV>> span(Function1<KV, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<KV> dropWhile(Function1<KV, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<KV, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<KV, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<KV, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<KV, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<KV, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<KV> find(Function1<KV, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<KV, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<KV> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.class.grouped((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<KV>, Iterator<KV>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<KV> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<KV> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<KV> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<KV> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<KV, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<KV, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, KV, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<KV, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, KV, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<KV, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, KV, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<KV, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, KV, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<KV, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, KV, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<KV> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<KV> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<KV> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<KV> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<KV> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, KV, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<KV, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            public boolean hasNext() {
                return this.rocksIterator$1.isValid() && ByteArrayUtils$.MODULE$.hasPrefix(this.rocksIterator$1.key(), this.prefix$1);
            }

            /*
             * WARNING - void declaration
             */
            public KV next() {
                void var1_1;
                KV kv = new KV(this.rocksIterator$1.key(), this.rocksIterator$1.value());
                this.rocksIterator$1.next();
                return var1_1;
            }
            {
                this.prefix$1 = prefix$1;
                this.rocksIterator$1 = rocksIterator$1;
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
            }
        };
    }

    public RocksDbStore(RocksDbConfiguration config) {
        this.config = config;
        Logging.class.$init$((Logging)this);
        RocksDB.loadLibrary();
    }
}

