package in.clouthink.daas.bm.core;

/**
 * All the business message will be put into the manager , then sent out by the underlying impl
 *
 * @author dz
 */
public interface BusinessMessageManager {

	/**
	 * The message is sent in sync or async mode ,
	 * the response handler will be called when required.
	 *
	 * @param handler the response handler
	 */
	void register(BusinessMessageResponseHandler handler);

	/**
	 * The message target parser
	 *
	 * @param parser the target parser
	 */
	void register(BusinessMessageTargetParser parser);

	/**
	 * The message request handler
	 *
	 * @param handler
	 */
	void register(BusinessMessageRequestHandler handler);

	/**
	 * The request will be processed immediately but the message won't be send out immediately
	 * which is decided by the underlying impl ( in some occasion, the message ending is suspend ,
	 * the sender won't send the message until the message ending is re-active)
	 *
	 * @param target
	 * @param request
	 */
	void process(String target, BusinessMessageRequest request);

	/**
	 * The request will be processed immediately but the message won't be send out immediately
	 * which is decided by the underlying impl ( in some occasion, the message ending is suspend ,
	 * the sender won't send the message until the message ending is re-active)
	 *
	 * @param receiver
	 * @param request
	 */
	void process(MessageReceiver receiver, BusinessMessageRequest request);

}
