package in.clouthink.daas.bm.core;

import java.io.Serializable;
import java.util.Map;

/**
 * Send message request
 */
public interface BusinessMessageRequest<T> extends Serializable {

	/**
	 * @return the category of message
	 */
	BusinessMessageType getType();

	/**
	 * @return the category of message ( for business )
	 */
	String getCategory();

	/**
	 * @return the uniform code for the business message ,
	 * sometimes the code is used to locate the message in the queue
	 * ( the failed message will be sent again )
	 */
	String getCode();

	/**
	 * @return the message title
	 */
	String getTitle();

	/**
	 * @return the message body
	 */
	T getBody();

	/**
	 * @return the ext attrs
	 */
	Map<String,Object> getAttributes();

	/**
	 * @return the sender of the message
	 */
	MessageSender getSender();
}
