package in.clouthink.daas.bm.core.impl;

import in.clouthink.daas.bm.core.BusinessMessageTarget;
import in.clouthink.daas.bm.core.BusinessMessageTargetParser;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;

/**
 * @author dz
 */
public class BusinessMessageTargetParserImpl implements BusinessMessageTargetParser {

	@Override
	public Iterable<BusinessMessageTarget> parse(String targetExpression) {
		if (StringUtils.isEmpty(targetExpression)) {
			return Arrays.asList();
		}
		String[] splitter = targetExpression.split(";");
		ArrayList<BusinessMessageTarget> result = new ArrayList();
		for (String item : splitter) {
			if (StringUtils.isEmpty(item)) {
				continue;
			}
			String[] splitTarget = item.split(":");
			if (splitTarget.length != 2) {
				throw new IllegalArgumentException(String.format("Unsupported target format '%s'", item));
			}
			BusinessMessageTargetImpl target = new BusinessMessageTargetImpl();
			target.setType(splitTarget[0]);
			target.setValues(splitTarget[1].split(","));
			result.add(target);
		}
		return result;
	}

}
