package in.clouthink.daas.bm.core.impl;

import in.clouthink.daas.bm.core.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * The dummy impl.
 */
public class DummyBusinessMessageRequestHandler implements BusinessMessageRequestHandler {

	private static final Log logger = LogFactory.getLog(DummyBusinessMessageRequestHandler.class);

	@Override
	public void onRequest(MessageReceiver messageReceiver,
						  BusinessMessageRequest request,
						  BusinessMessageResponseHandler handler) {
		if (logger.isDebugEnabled()) {
			logger.debug(String.format("Handle the request '%s' to receiver '%s'", request, messageReceiver));
		}
	}

	@Override
	public void onRequest(BusinessMessageTarget target,
						  BusinessMessageRequest request,
						  BusinessMessageResponseHandler handler) {
		if (logger.isDebugEnabled()) {
			logger.debug(String.format("Handle the request '%s' to target '%s'", request, target));
		}
	}

}
