package in.clouthink.daas.bm.domain.model;

import java.util.Date;
import java.util.Map;

/**
 * The business message transfers in the system
 *
 * @author dz
 */
public interface BusinessMessage<T> {

	/**
	 * @return the uuid to identify the business message
	 */
	String getId();

	/**
	 * @return the category of message ( for business )
	 */
	String getCategory();

	/**
	 * @return the message title
	 */
	String getTitle();

	/**
	 * @return the message body
	 */
	T getBody();

	/**
	 * @return
	 */
	Map<String,?> getAttributes();

	/**
	 * @return
	 */
	String getReceiverId();

	/**
	 * @return
	 */
	String getReceiverType();

	/**
	 * @return
	 */
	String getReceiverName();

	/**
	 * @return
	 */
	String getSenderId();

	/**
	 * @return
	 */
	String getSenderType();

	/**
	 * @return
	 */
	String getSenderName();

	/**
	 * @return
	 */
	Date getSendAt();

	/**
	 * @return true the message is read
	 */
	boolean isRead();

	/**
	 * @return
	 */
	Date getReadAt();

	/**
	 * @return true the message is processed ( if the message is process-required)
	 */
	boolean isProcessed();

	/**
	 * @return
	 */
	Date getProcessedAt();

	/**
	 * @return true the message is deleted by owner (sendTo)
	 */
	boolean isDeleted();

	/**
	 * @return
	 */
	Date getDeletedAt();

}
