package in.clouthink.daas.bm.domain.model;

import in.clouthink.daas.bm.core.BusinessMessageType;

import java.util.Map;

/**
 * If the business message is sent in failure, it will be log down
 *
 * @author dz
 */
public interface FailureMessage<T> {

	/**
	 * @return the uuid to identify the business message
	 */
	String getId();

	/**
	 * @return the type to indicate which channel will be sent through
	 */
	BusinessMessageType getType();

	/**
	 * @return the category of message ( for business )
	 */
	String getCategory();

	/**
	 * @return the message title
	 */
	String getTitle();

	/**
	 * @return the message body
	 */
	T getBody();

	/**
	 * @return the ex attrs
	 */
	Map<String,?> getAttributes();

	/**
	 * @return the target (in string expression) which will send to
	 */
	String getTarget();

	/**
	 * @return how many times re-tried
	 */
	int getRetried();

	/**
	 * @return the latest error code
	 */
	String getErrorCode();

	/**
	 * @return the latest error message
	 */
	String getErrorMessage();

	/**
	 * @return the latest error message in detail
	 */
	String getDebugMessage();

	/**
	 * @return the final status , succeed or not ( because some type of message can be re-send )
	 */
	boolean isFinalSucceed();

}
