package in.clouthink.daas.bm.domain.request;

/**
 * @author dz
 */
public interface BusinessMessageQueryRequest extends DateRangedQueryRequest {

	/**
	 * @return the category of business message
	 */
	String getCategory();

	/**
	 * @return the id of business message receiver
	 */
	String getReceiverId();

	/**
	 * @return the name of business message receiver
	 */
	String getReceiverName();

	/**
	 * @return true the business message is marked as read
	 */
	Boolean getRead();

	/**
	 * @return true the business message is marked as deleted
	 */
	Boolean getDeleted();

}
