package in.clouthink.daas.bm.domain.rest;

import in.clouthink.daas.bm.core.MessageReceiver;
import in.clouthink.daas.bm.domain.request.BusinessMessageQueryParameter;
import in.clouthink.daas.bm.security.SecurityContexts;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.IOException;

/**
 * The query part of business message rest api
 *
 * @author dz
 */
@Controller
@RequestMapping(value = "/api")
public class BusinessMessageRestController {

	@Autowired
	private BusinessMessageRestSupport sharedBusinessMessageRestSupport;

	@RequestMapping(value = "/businessMessages/{id}", method = RequestMethod.GET)
	@ResponseBody
	public BusinessMessageDetail getBusinessMessageDetail(@PathVariable String id) throws IOException {
		MessageReceiver messageReceiver = SecurityContexts.getContext().asReceiver();
		return sharedBusinessMessageRestSupport.getBusinessMessageDetail(id, messageReceiver);
	}

	@RequestMapping(value = "/businessMessages", method = RequestMethod.GET)
	@ResponseBody
	public Page<BusinessMessageSummary> listBusinessMessagePage(BusinessMessageQueryParameter request) {
		MessageReceiver messageReceiver = SecurityContexts.getContext().asReceiver();
		return sharedBusinessMessageRestSupport.listBusinessMessagePage(request, messageReceiver);
	}

	@RequestMapping(value = "/businessMessages/{id}/read", method = RequestMethod.POST)
	@ResponseBody
	public void readBusinessMessage(@PathVariable String id) throws IOException {
		MessageReceiver messageReceiver = SecurityContexts.getContext().asReceiver();
		sharedBusinessMessageRestSupport.readBusinessMessage(id, messageReceiver);
	}

	@RequestMapping(value = "/businessMessages/{id}/process", method = RequestMethod.POST)
	@ResponseBody
	public void processBusinessMessage(@PathVariable String id) throws IOException {
		MessageReceiver messageReceiver = SecurityContexts.getContext().asReceiver();
		sharedBusinessMessageRestSupport.processBusinessMessage(id, messageReceiver);
	}

	@RequestMapping(value = "/businessMessages/{id}", method = RequestMethod.DELETE)
	@ResponseBody
	public void deleteBusinessMessage(@PathVariable String id) throws IOException {
		MessageReceiver messageReceiver = SecurityContexts.getContext().asReceiver();
		sharedBusinessMessageRestSupport.deleteBusinessMessage(id, messageReceiver);
	}

}
